/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineProbeResult.java 8846 2011-09-13 08:09:18Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/**
 * Value Object holding a result of a Probe.
 * @author durieuxp
 */
public class JasmineProbeResult implements Serializable {

    private static final long serialVersionUID = -6711641493993118511L;

    /**
     * Ident of the Probe
     */
    private String probeId;

    /**
     * Indicator Values
     */
    private Collection<JasmineIndicatorValue> ivalues;

    /**
     * Constructor
     */
    public JasmineProbeResult(String probeId) {
        this.probeId = probeId;
        this.ivalues = new ArrayList<JasmineIndicatorValue>();
    }

    /**
     * Add result for 1 indicator
     * @param value
     */
    public void addValue(JasmineIndicatorValue value) {
        ivalues.add(value);
    }

    /**
     * Get the values for this result set.
     * @return a Collection of JasmineIndicatorValue objects.
     */
    public Collection<JasmineIndicatorValue> getValues() {
        return ivalues;
    }

    public String getProbeId() {
        return probeId;
    }
}
