/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineIndicator.java 8918 2011-09-16 13:00:42Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

/**
 * A JasmineIndicator defines how to obtain the value to be monitored
 * @author durieuxp
 */
public class JasmineIndicator {

    /**
     * Name of this indicator
     * can be provided by the user or generated.
     * Must be unique inside of an agent
     */
    protected String name;

    /**
     * type of Indicator: should identify the CollectorService to be used.
     */
    private String type = null;

    /**
     * Scale factor: The rough result will be divided by this value.
     * Default is 1.
     */
    private int scale = 1;

    /**
     * Type specific parameters
     */
    private Map<String, String> properties = new HashMap<String, String>();

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getScale() {
        return scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public Map<String, String> getProperties() {
        return properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    /**
     * Build a full description of this object.
     * @return
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("JasmineIndicator " + name);
        buffer.append("\n> type : " + type);
        buffer.append("\n> scale : " + scale);
        for (String key : properties.keySet()) {
            buffer.append("\n> " + key + " = " + properties.get(key));
        }
        return buffer.toString();
    }

    /**
     * Build a single line description of this object.
     * @return
     */
    public String toLine()  {
        String formattedName = (name + "                              ").substring(0, 30);
        return formattedName + type;
    }
}
