/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineIndicatorValue.java 8995 2011-09-27 07:16:35Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/**
 * This is the structure of data returned by each Collectors.
 * It will be included in a List inside a JasmineProbeResult that will
 * be given later to each Outer.
 * @author durieuxp
 */
public class JasmineIndicatorValue implements Serializable {

    /**
     * Indicator Name.
     */
    private String name;

    /**
     * Target name
     */
    private String target;

    /**
     * Additional Metadata, depending on the Collector type.
     */
    private HashMap<String, String> metadata;

    /**
     * Collection of values.
     * We have a Collection because indicators may be composite.
     */
    private Collection<JasmineSingleResult> values;

    /**
     * Constructor
     */
    public JasmineIndicatorValue() {
        metadata = new HashMap<String, String>();
        values = new ArrayList<JasmineSingleResult>();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTarget() {
        return target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public HashMap<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Add a metadata to the list.
     * @param key
     * @param value
     */
    public void addMetadata(String key, String value) {
        this.metadata.put(key, value);
    }

    public Collection<JasmineSingleResult> getValues() {
        return values;
    }

    public void setValues(Collection<JasmineSingleResult> values) {
        this.values = values;
    }

    /**
     * Add a JasmineSingleResult to the list of result values
     * @param value
     */
    public void addValue(JasmineSingleResult value) {
        this.values.add(value);
    }

    /**
     * Get the JasmineSingleResult by its name
     * @param name
     * @return  JasmineSingleResult  or null if does not exist
     */
    public JasmineSingleResult getValue(String name) {
        for (JasmineSingleResult res : this.values) {
            if (res.getName().equals(name)) {
                return res;
            }
        }
        return null;
    }

    /**
     * Get the timestamp of the values.
     * @return the timestamp
     */
    public long getTimestamp() {
        long ret = 0;
        // take the biggest one.
        for (JasmineSingleResult res : values) {
             if (res.getTimestamp() > ret) {
                 ret = res.getTimestamp();
             }
        }
        return ret;
    }
}
