/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: TypeNotSupportedException.java 8877 2011-09-14 11:18:20Z durieuxp $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe;

/**
 * Exception thrown when trying to use a type not supported.
 */
public class TypeNotSupportedException extends JasmineProbeException {

    /**
     * Exception UID.
     */
    private static final long serialVersionUID = 1L;

    /**
     * Create a JasmineProbeException
     * @param message message about the exception
     */
    public TypeNotSupportedException(String message) {
        super(message);
    }
}
