/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasmineCollectorService.java 8926 2011-09-16 15:04:22Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collector;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasminePropertyInfo;

import java.util.List;

/**
 * This interface is implemented by all the CollectorServices
 * @author durieuxp
 */
public interface JasmineCollectorService {

    /**
     * Get the Collector for this JasmineIndicator VO
     * Create it if does not exist yet.
     * @param indicator VO
     * @param period nb of seconds between 2 measures
     * @param probeid
     * @return the Outer
     */
    JasmineCollector getCollector(JasmineIndicator indicator, int period, String probeid) throws JasmineCollectorException;

    /**
     * Retrieve the description of all specific properties hidden in JasmineCollector
     * Return a List of all properties with their description
     * @return  List of property descriptions
     */
    List<JasminePropertyInfo> getPropertiesInfo();

    /**
     * Remove Collectors attached to this Indicator.
     * Called usually when the indicator has changed or is removed.
     * @param name  Indicator name
     */
    void removeCollectors(String name);

    /**
     * return the List of indicators used by this indicator.
     * @param indic JasmineIndicator
     * @return
     */
    List<String> getDependantIndicators(JasmineIndicator indic);
}
