/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JasminePropertyInfo.java 8874 2011-09-14 09:27:31Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe;

/**
 * Information about a Jasmine Property used in the different interfaces
 * @author durieuxp
 */
public class JasminePropertyInfo {

    /**
     * name of the property
     */
    protected String name;

    /**
     * Description of this property
     */
    protected String description;

    /**
     * true if property is required.
     */
    protected boolean required;

    /**
     * Empty constructor, needed for MXBean
     */
    public JasminePropertyInfo() {
    }

    /**
     * Constructor
     * @param description
     * @param required
     */
    public JasminePropertyInfo(String name, String description, boolean required) {
        this.name = name;
        this.description = description;
        this.required = required;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public boolean isRequired() {
        return required;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    /**
     * Build a line representing this JasminePropertiyInfo
     * @return String line
     */
    public String toString() {
        StringBuffer buffer = new StringBuffer(80);
        if (required) {
            buffer.append("* ");
        } else {
            buffer.append("  ");
        }
        String formattedname = (name + "                ").substring(0, 16);
        buffer.append(formattedname);
        buffer.append(description);
        return buffer.toString();
    }

}
