/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.outer;

import org.ow2.jasmine.probe.JasmineProbeResult;


/**
 * Interface implemented by all Outer managed by the OuterManager
 * Used to put new data collected by probes.
 * Each Outer manages a queue of JasmineProbeResult elements.
 * @author durieuxp
 */
public interface JasmineOuter {

    /**
     * Add this data to the Outer's queue.
     * @param data the JasmineProbeResult element to be added to the queue.
     */
    void publishData(JasmineProbeResult data);

    /**
     * Return the name of the output corresponding to this outer
     */
    String getOutputName();

    /**
     * Flush the Outer.
     */
    void flushData();

    /**
     * Mark removed
     */
    void remove();

    /**
     * @return true if the collector was marked as removed
     */
    boolean isRemoved();
}
