/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collector;

import org.ow2.jasmine.probe.JasmineIndicatorValue;

/**
 * Common interface for JasmineProbe collectors.
 */
public interface JasmineCollector {
    /**
     * Retrieve the last results for this indicator.
     * Called by the running probe every 'period' seconds.
     * It may also be called by another collector that uses this one as a source for
     * values to be processed.
     * @return JasmineIndicatorValue or null if no result available
     */
    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException;

    /**
     * Return the name of the indicator corresponding to this Collector
     */
    public String getIndicatorName();

    /**
     *
     * @return Return the Id of the probe corresponding to this Collector
     */
    public String getProbeId();

    /**
     * Stop polling
     */
    public void stopPolling();

    /**
    * Start polling
    */
   public void startPolling();

   /**
    * Mark removed
    */
   public void remove();

   /**
    * @return true if the collector was marked as removed
    */
   public boolean isRemoved();
}
