/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collector;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineCollectorInfo;
import org.ow2.jasmine.probe.JasmineProbe;
import org.ow2.jasmine.probe.JasminePropertyInfo;

import java.util.List;

/**
 * This interface is implemented by all the CollectorServices
 * @author durieuxp
 * @author danesa
 */
public interface JasmineCollectorService {

    /**
     * Create a Collector instance corresponding to a JasmineIndicator and a JasmineProbe.
     * @param indicator the given indicator's definition
     * @param probe the definition of the probe in which the indicator is used
     * @return the Collector corresponding to the given indicator
     */
    JasmineCollector getCollector(JasmineIndicator indicator, JasmineProbe probe) throws JasmineCollectorException;

    /**
     * Retrieve the description of all specific properties hidden in JasmineCollector
     * Return a List of all properties with their description
     * @deprecated
     * @return  List of property descriptions
     */
    List<JasminePropertyInfo> getPropertiesInfo();

    /**
     * Get the Information about the Collector
     * @return JasmineIndicatorTypeInfo
     */
    JasmineCollectorInfo getCollectorInfo();

    /**
     * Remove Collectors attached to this Indicator.
     * Called usually when the indicator has changed or is removed.
     * May be called also when a probe is removed. In this case, the
     * probeId must be provided.
     * @param name  Indicator name
     * @param probeId Probe name. If not null, only remove collectors
     * corresponding to the given indicator and probe.
     */
    void removeCollectors(String name, String probeId);

    /**
     * Remove a target. This operation has no effect on collector services which
     * use implicit targets. It has side effect on services like 'jmx' that associate
     * workers to targets.
     * @param name the name of the target to remove
     */
    void removeTarget(String name);

    /**
     * Return the List of indicators used by this indicator.
     * @param indic JasmineIndicator
     * @return
     */
    List<String> getDependantIndicators(JasmineIndicator indic);

    /**
     * Return the list of targets used by this indicator
     * @param indic JasmineIndicator
     * @return
     */
    List<String> getDependantTargets(JasmineIndicator indic);
}
