/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.jmxconnection.simple;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxConnectionFactoryImpl
implements JmxConnectionFactory {
    private JMXConnector connector = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private String protocolProviders = null;
    private static Log logger = LogFactory.getLog(JmxConnectionService.class);

    public JmxConnectionFactoryImpl(String url, Map<String, String> props) throws JmxConnectionException {
        logger.debug((Object)url, new Object[0]);
        this.url = url;
        JMXServiceURL serviceUrl = null;
        try {
            serviceUrl = new JMXServiceURL(url);
        }
        catch (MalformedURLException e) {
            throw new JmxConnectionException(e);
        }
        if (props != null) {
            this.user = props.get("user");
            this.password = props.get("pwd");
            this.protocolProviders = props.get("provider");
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            JMXServiceURL jmxUrl;
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Map<String, String[]> env = null;
            if (this.user != null && this.password != null) {
                if (env == null) {
                    env = new HashMap<String, String>(2);
                }
                String[] creds = new String[]{this.user, this.password};
                env.put("jmx.remote.credentials", creds);
            }
            if (this.protocolProviders != null) {
                if (env == null) {
                    env = new HashMap(2);
                }
                env.put("jmx.remote.protocol.provider.pkgs", (String[])this.protocolProviders);
            }
            if ("t3".equals((jmxUrl = new JMXServiceURL(this.url)).getProtocol())) {
                env = this.setCredentialsForT3(env);
            }
            this.connector = JMXConnectorFactory.connect(serviceUrl, env);
            logger.info((Object)"Connector created for target {0}.", new Object[]{url});
        }
        catch (SecurityException e) {
            logger.info((Object)"SecurityException raised for target {0}.", new Object[]{url});
            throw new JmxConnectionException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info((Object)"IOException raised when trying to connect to target {0}: {1}", new Object[]{url, e.getMessage()});
            throw new JmxConnectionException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void close() throws JmxConnectionException {
        try {
            this.connector.close();
            logger.info((Object)"JMX connection closed for target {0}", new Object[]{this.url});
        }
        catch (IOException e) {
            logger.warn((Object)"Exception when trying to close JMX connector for target {0} ({1})", new Object[]{this.url, e.toString()});
            throw new JmxConnectionException(e);
        }
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        MBeanServerConnection mbsc = null;
        try {
            mbsc = this.connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            logger.info((Object)"IOException raised when trying to get connection to target {0}: {1}", new Object[]{this.url, e.getMessage()});
            throw new JmxConnectionException(e);
        }
        return mbsc;
    }

    private Map setCredentialsForT3(Map map) {
        if (!map.containsKey("java.naming.security.principal") && !map.containsKey("java.naming.security.credentials") && map.containsKey("jmx.remote.credentials")) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.putAll(map);
            String[] cred = (String[])map.get("jmx.remote.credentials");
            newMap.put("java.naming.security.principal", cred[0]);
            newMap.put("java.naming.security.credentials", cred[1]);
            return newMap;
        }
        return map;
    }
}

