/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.shell;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.PropertyUtils;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbeException;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.JasminePropertyInfo;
import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JasmineProbeCommand {
    private JCommander commander = null;
    private JasmineProbeCommandParams params = new JasmineProbeCommandParams();

    public abstract String getName();

    public abstract JasmineProbeManager getProbeManager();

    public void setParams(JasmineProbeCommandParams params) {
        this.params = params;
    }

    public JasmineProbeCommandParams getParams() {
        return this.params;
    }

    protected boolean parseOptions(String line, PrintStream out, PrintStream err) {
        String[] args = this.getArgs(line.substring(this.getName().length()).trim());
        try {
            this.commander = new JCommander((Object)this.params, args);
            this.commander.setProgramName(this.getName());
        }
        catch (ParameterException pe) {
            err.println(pe.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getProperties() {
        return null;
    }

    public String getUsage() {
        if (this.commander == null) {
            String[] args = this.getArgs(this.getRequiredOptions());
            this.commander = new JCommander((Object)this.params, args);
            this.commander.setProgramName(this.getName());
        }
        StringBuilder sb = new StringBuilder();
        this.commander.usage(sb);
        String props = this.getProperties();
        if (props != null) {
            sb.append("\n");
            sb.append(props);
        }
        return new String(sb).substring(7);
    }

    public String getRequiredOptions() {
        return "";
    }

    protected Map<String, String> parseProperties(Collection<JasminePropertyInfo> propsInfo, JasmineProbeCommandParams params) throws JasmineProbeException {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (JasminePropertyInfo propInfo : propsInfo) {
            String key = propInfo.getName();
            String value = null;
            try {
                value = (String)PropertyUtils.getSimpleProperty((Object)params, (String)key);
            }
            catch (Exception e) {
                throw new JasmineProbeException(this.getName() + " command: cannot get options for " + key + " property (" + e.toString() + ")");
            }
            properties.put(key, value);
        }
        return properties;
    }

    private String[] getArgs(String argsLine) {
        String[] args = null;
        if (argsLine.length() == 0) {
            args = new String[]{};
        } else {
            StringTokenizer st = new StringTokenizer(argsLine);
            args = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i++] = st.nextToken();
            }
        }
        return args;
    }

    protected boolean validParam(String param) {
        int indexEqual = param.indexOf("=");
        if (indexEqual == -1) {
            return false;
        }
        if (indexEqual < 1) {
            return false;
        }
        try {
            param.substring(indexEqual + 1);
            return true;
        }
        catch (IndexOutOfBoundsException obe) {
            return false;
        }
    }

    protected void createIndicator(String commandName, JasmineIndicator indicator, PrintStream out, PrintStream err) {
        try {
            this.getProbeManager().createIndicator(indicator);
            out.println(commandName + " " + indicator.getName() + " was successfull");
        }
        catch (JasmineProbeException e) {
            err.println(commandName + " " + indicator.getName() + " failed");
            err.println((Object)e);
            return;
        }
    }
}

