/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.api.impl;

import com.conwet.silbops.api.FeedbackListener;
import com.conwet.silbops.api.IConnectionFactory;
import com.conwet.silbops.api.NotificationListener;
import com.conwet.silbops.api.PubEndpoint;
import com.conwet.silbops.api.SubEndpoint;
import com.conwet.silbops.api.impl.XJSPEndpoint;
import com.conwet.silbops.api.impl.XJSPPubEndpoint;
import com.conwet.silbops.api.impl.XJSPSubEndpoint;
import com.conwet.xjsp.XJSPConnectionBuilder;
import com.conwet.xjsp.features.Session;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;

public class ConnectionFactoryImpl
implements IConnectionFactory {
    private final String hostname;
    private final int port;

    public ConnectionFactoryImpl(URI url) {
        this.hostname = url.getHost();
        this.port = url.getPort() < 0 ? 2222 : url.getPort();
    }

    @Override
    public PubEndpoint openPubEndpoint() throws IOError {
        XJSPPubEndpoint endpoint = new XJSPPubEndpoint();
        this.connectEndpoint(endpoint);
        return endpoint;
    }

    @Override
    public PubEndpoint openPubEndpoint(FeedbackListener listener) throws IOError {
        XJSPPubEndpoint endpoint = new XJSPPubEndpoint(listener);
        this.connectEndpoint(endpoint);
        return endpoint;
    }

    @Override
    public SubEndpoint openSubEndpoint() throws IOError {
        XJSPSubEndpoint endpoint = new XJSPSubEndpoint();
        this.connectEndpoint(endpoint);
        return endpoint;
    }

    @Override
    public SubEndpoint openSubEndpoint(NotificationListener listener) throws IOError {
        XJSPSubEndpoint endpoint = new XJSPSubEndpoint(listener);
        this.connectEndpoint(endpoint);
        return endpoint;
    }

    private void connectEndpoint(XJSPEndpoint endpoint) throws IOError {
        try {
            Session session = new XJSPConnectionBuilder().addFeatureHandler("ps", endpoint).connect(this.hostname, this.port);
            endpoint.setSession(session);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }
}

