/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.api.impl;

import com.conwet.silbops.api.NotificationListener;
import com.conwet.silbops.api.SubEndpoint;
import com.conwet.silbops.api.impl.XJSPEndpoint;
import com.conwet.silbops.model.Filter;
import com.conwet.silbops.model.Notification;
import com.conwet.xjsp.features.Message;
import com.conwet.xjsp.features.Session;
import java.io.IOError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XJSPSubEndpoint
extends XJSPEndpoint
implements SubEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(XJSPSubEndpoint.class);
    private final Set<NotificationListener> listeners = new HashSet<NotificationListener>();

    XJSPSubEndpoint(NotificationListener listener) {
        this();
        this.listeners.add(listener);
    }

    XJSPSubEndpoint() {
    }

    @Override
    public void subscribe(Filter filter) {
        try {
            JSONObject payload = new JSONObject();
            payload.put("filter", filter.toJSON());
            this.session.sendMessage(this.getFeatureName(), "subscribe", payload);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    @Override
    public void unsubscribe(Filter filter) {
        try {
            JSONObject payload = new JSONObject();
            payload.put("filter", filter.toJSON());
            this.session.sendMessage(this.getFeatureName(), "unsubscribe", payload);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    @Override
    public void sendFeedback(Notification msg, Notification feedback) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void addNotificationListener(NotificationListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeNotificationListener(NotificationListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void handleMessage(Message message, Session session) throws Exception {
        if ("notify".equals(message.getMessageType())) {
            JSONObject payload = (JSONObject)message.getPayload();
            Notification not = Notification.fromJSON((JSONObject)payload.get("notification"));
            for (NotificationListener l : this.listeners) {
                l.receiveNotification(not);
            }
        } else {
            logger.warn("Unhandled message: {}", message);
        }
    }
}

