/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.session;

import com.conwet.xjsp.errors.ConnectionException;
import com.conwet.xjsp.json.JSONUtil;
import com.conwet.xjsp.session.ConnectionContext;
import com.conwet.xjsp.session.ConnectionState;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosingState
implements ConnectionState {
    private static final Logger logger = LoggerFactory.getLogger(ClosingState.class);

    @Override
    public void start(ConnectionContext context) throws ConnectionException {
        context.getChannel().sendFragment("]}");
    }

    @Override
    public void newData(ConnectionContext context) {
        try {
            String stanza = JSONUtil.extractStanza(context.getBuffer());
            if (stanza == null) {
                return;
            }
            if (!"]}".equals(stanza)) {
                logger.error("Unexpected message when closing the connection: '{}'", (Object)stanza);
            }
        }
        catch (ParseException ex) {
            logger.error("Syntax error when closing the connection: '{}'", (Object)ex.getMessage(), (Object)ex);
        }
        context.dispose();
    }

    @Override
    public void timeout(ConnectionContext context) {
        logger.error("Expired timeout while closing");
        context.dispose();
    }

    @Override
    public long getTimeoutPeriod(ConnectionContext context) {
        return 10000L;
    }
}

