/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.util;

import com.conwet.silbops.util.Bag;
import com.conwet.silbops.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiValueMap<K, V> {
    private final Map<K, Bag<V>> map = new HashMap<K, Bag<V>>();

    public void add(K key, V value) {
        Bag<Object> bag = this.map.get(key);
        if (bag == null) {
            bag = new Bag();
            this.map.put(key, bag);
        }
        bag.add(value);
    }

    public void add(K key, Collection<V> values) {
        Bag<Object> bag = this.map.get(key);
        if (bag == null) {
            bag = new Bag();
            this.map.put(key, bag);
        }
        bag.addAll(values);
    }

    public Collection<V> get(K key) {
        Bag<Object> bag = this.map.get(key);
        if (bag == null) {
            bag = new Bag();
        }
        return bag;
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Set<Entry<K, V>> entries() {
        HashSet<Entry<K, V>> result = new HashSet<Entry<K, V>>();
        for (Map.Entry<K, Bag<V>> entry : this.map.entrySet()) {
            for (Object value : entry.getValue()) {
                result.add(new Entry(entry.getKey(), value));
            }
        }
        return result;
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public void remove(K key, V value) {
        List list = this.map.get(key);
        if (list != null) {
            list.remove(value);
            if (list.isEmpty()) {
                this.map.remove(key);
            }
        }
    }

    public int size() {
        int s = 0;
        for (Bag<V> list : this.map.values()) {
            s += list.size();
        }
        return s;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiValueMap other = (MultiValueMap)obj;
        if (!((Object)this.map.keySet()).equals(other.map.keySet())) {
            return false;
        }
        for (K key : this.map.keySet()) {
            if (((Object)this.get(key)).equals(other.get(key))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.map != null ? ((Object)this.map).hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("{");
        boolean first = true;
        for (K key : this.keys()) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(key.toString()).append(": [");
            str.append(StringUtil.join(this.get(key), ", "));
            str.append("]");
        }
        str.append("}");
        return str.toString();
    }

    public static class Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K key() {
            return this.key;
        }

        public V value() {
            return this.value;
        }
    }
}

