/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.features;

import com.conwet.xjsp.features.ErrorMessage;
import com.conwet.xjsp.features.FeatureHandler;
import com.conwet.xjsp.features.ImmutableErrorMessage;
import com.conwet.xjsp.features.Message;
import com.conwet.xjsp.features.Session;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXJSPHandler
implements FeatureHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultXJSPHandler.class);

    @Override
    public void handleMessage(Message message, Session session) throws Exception {
        if ("error".equals(message.getMessageType())) {
            ErrorMessage error;
            try {
                error = this.toErrorMessage(message.getPayload());
            }
            catch (IllegalArgumentException ex) {
                logger.error("Malformed error message", ex);
                return;
            }
            this.doHandleError(error, session);
        } else {
            logger.warn("Unhandled xjsp message of type {}", (Object)message.getMessageType());
        }
    }

    @Override
    public String getFeatureName() {
        return "xjsp";
    }

    public void doHandleError(ErrorMessage message, Session session) throws Exception {
        logger.warn("Unhandled error message {}", message);
    }

    private ErrorMessage toErrorMessage(Object payload) throws IllegalArgumentException {
        try {
            JSONObject object = (JSONObject)payload;
            long code = (Long)object.get("code");
            String message = (String)object.get("message");
            String id = null;
            if (object.containsKey("id")) {
                id = (String)object.get("id");
            }
            return new ImmutableErrorMessage(code, message, id);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Malformed error message");
        }
    }
}

