/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.aggregate.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineAggregateService;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAggregateCollector
extends JCollector {
    private int ope;
    private String operation;
    public static final int OP_MIN = 1;
    public static final int OP_MAX = 2;
    public static final int OP_SUM = 3;
    public static final int OP_AVERAGE = 4;
    private JasmineCollector source = null;
    private String merged;

    public JAggregateCollector(String name, JasmineIndicator def, int period, String operation, JasmineCollector source, String merged) {
        super(name, def, period);
        this.operation = operation;
        this.ope = 0;
        if (operation.equalsIgnoreCase("min")) {
            this.ope = 1;
        } else if (operation.equalsIgnoreCase("max")) {
            this.ope = 2;
        } else if (operation.equalsIgnoreCase("sum")) {
            this.ope = 3;
        } else if (operation.equalsIgnoreCase("average")) {
            this.ope = 4;
        }
        this.ope = this.ope;
        this.source = source;
        this.merged = merged;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue current = this.source.getLastResult();
        if (current == null) {
            return null;
        }
        JasmineAggregateService aggserv = this.probeManager.getAggregate(this.operation);
        if (aggserv != null) {
            return aggserv.aggregate(current);
        }
        if (this.ope == 2) {
            return this.max(current);
        }
        throw new JasmineCollectorException("Unimplemented " + this.operation + " aggregate operation");
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    private Number max(Map<String, Number> map) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : map.values()) {
            if (ret == null) {
                ret = val;
                continue;
            }
            if (this.diffValues(val, ret) <= 0L) continue;
            ret = val;
        }
        return ret;
    }

    private Number min(Map<String, Number> map) throws JasmineCollectorException {
        Number ret = null;
        for (Number val : map.values()) {
            if (ret == null) {
                ret = val;
                continue;
            }
            if (this.diffValues(val, ret) >= 0L) continue;
            ret = val;
        }
        return ret;
    }

    private Number sum(Map<String, Number> map) throws JasmineCollectorException {
        Long ret = this.addValues(map.values());
        return ret;
    }

    private Number average(Map<String, Number> map) throws JasmineCollectorException {
        long ret = this.addValues(map.values());
        int nbval = map.values().size();
        return ret / (long)nbval;
    }

    private JasmineIndicatorValue max(JasmineIndicatorValue source) throws JasmineCollectorException {
        JasmineIndicatorValue maxIndicValue = new JasmineIndicatorValue();
        maxIndicValue.setName(source.getName());
        Collection results = source.getValues();
        if (results.isEmpty()) {
            maxIndicValue.setValues(results);
            return maxIndicValue;
        }
        JasmineSingleNumberResult maxResult = new JasmineSingleNumberResult();
        Number maxValue = null;
        String maxName = null;
        HashMap maxProps = null;
        for (JasmineSingleResult result : results) {
            if (maxValue == null) {
                maxValue = (Number)result.getValue();
                maxName = result.getName();
                maxProps = result.getProperties();
                continue;
            }
            Number value = (Number)result.getValue();
            if (this.diffValues(maxValue, value) >= 0L) continue;
            maxValue = value;
            maxName = result.getName();
            maxProps = result.getProperties();
        }
        maxResult.setValue(maxValue);
        maxResult.setTimestamp(System.currentTimeMillis());
        maxResult.setName(maxName);
        maxResult.setProperties(maxProps);
        ArrayList<JasmineSingleNumberResult> maxResults = new ArrayList<JasmineSingleNumberResult>();
        maxResults.add(maxResult);
        maxIndicValue.setValues(maxResults);
        return maxIndicValue;
    }
}

