/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesException;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtil {
    private static Log logger = LogFactory.getLog(JmxCollector.class);

    public static Set<ObjectName> getMBeans(MBeanServerConnection cnx, ObjectName on) throws IOException {
        QueryExp query = null;
        return cnx.queryNames(on, query);
    }

    public static List<String> getMBeanAttNames(MBeanServerConnection cnx, ObjectName on) throws IOException, JMException {
        MBeanAttributeInfo[] attsInfo;
        ArrayList<String> attNames = new ArrayList<String>();
        MBeanInfo mbeanInfo = cnx.getMBeanInfo(on);
        for (MBeanAttributeInfo attInfo : attsInfo = mbeanInfo.getAttributes()) {
            String attName = attInfo.getName();
            attNames.add(attName);
        }
        return attNames;
    }

    public static Attribute createNewIndexedAttribute(String contName, String index, Object elemValue) {
        String attName = FragmentUtil.nameForIndexElement(contName, index);
        Object attValue = elemValue;
        return new Attribute(attName, attValue);
    }

    public static Attribute createNewItemAttribute(String contName, String key, Object itemValue) {
        String attName = FragmentUtil.nameForItem(contName, key);
        Object attValue = itemValue;
        return new Attribute(attName, attValue);
    }

    public static Attribute getAttributeFragment(String name, Attribute att) throws FragmentNameException {
        if (name.equals(att.getName())) {
            return att;
        }
        if (FragmentUtil.nextElementIsKey(name, att.getName())) {
            String key = FragmentUtil.getKeyName(name, att.getName());
            try {
                Object itemValue = ComplexValuesUtil.getItem(att.getValue(), key);
                Attribute newAtt = JmxUtil.createNewItemAttribute(att.getName(), key, itemValue);
                return JmxUtil.getAttributeFragment(name, newAtt);
            }
            catch (ComplexValuesException e) {
                e.printStackTrace();
                throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
            }
        }
        if (FragmentUtil.nextElementIsIndex(name, att.getName())) {
            String indexes = FragmentUtil.getIndexes(name, att.getName());
            try {
                Object indexedValue = ComplexValuesUtil.getElement(att.getValue(), indexes);
                Attribute newAtt = JmxUtil.createNewIndexedAttribute(att.getName(), indexes, indexedValue);
                return JmxUtil.getAttributeFragment(name, newAtt);
            }
            catch (ComplexValuesException e) {
                e.printStackTrace();
                throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
            }
        }
        throw new FragmentNameException("Could not extract an attribute fragment having name: " + name + ". The source attribute has name: " + att.getName());
    }

    public static List<Attribute> getAttributeFragments(Attribute att) throws ComplexValuesException {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        String name = att.getName();
        Object value = att.getValue();
        if (ComplexValuesUtil.hasSimpleType(value)) {
            logger.debug((Object)("Return final fragment with name: " + name + " and value: " + value), new Object[0]);
            result.add(att);
            return result;
        }
        if (value instanceof CompositeData) {
            CompositeData compValue = (CompositeData)value;
            Set<String> keys = compValue.getCompositeType().keySet();
            for (String key : keys) {
                Object item = ComplexValuesUtil.getCompositeItem(compValue, key);
                String itemName = FragmentUtil.getNameForItem(name, key);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof TabularData) {
            TabularData tabData = (TabularData)value;
            Collection<?> values = tabData.values();
            for (Object tabValue : values) {
                CompositeData compValue = (CompositeData)tabValue;
                Object[] indexes = tabData.calculateIndex(compValue);
                String elemName = FragmentUtil.getNameForTabularElement(name, indexes);
                Attribute newAttribute = new Attribute(elemName, compValue);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof Map) {
            Map mapVal = (Map)value;
            Set keys = mapVal.keySet();
            for (Object key : keys) {
                String skey = key.toString();
                Object item = ComplexValuesUtil.getMapItem(mapVal, skey);
                String itemName = FragmentUtil.getNameForItem(name, skey);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value instanceof List) {
            List listVal = (List)value;
            for (int i = 0; i < listVal.size(); ++i) {
                String index = new Integer(i).toString();
                Object item = ComplexValuesUtil.getListElement(listVal, index);
                String itemName = FragmentUtil.getNameForItem(name, index);
                Attribute newAttribute = new Attribute(itemName, item);
                result.addAll(JmxUtil.getAttributeFragments(newAttribute));
            }
            return result;
        }
        if (value.getClass().isArray()) {
            try {
                Object[] oArray = (Object[])value;
                for (int i = 0; i < oArray.length; ++i) {
                    Object elem = oArray[i];
                    String elemName = FragmentUtil.getNameForArrayElement(name, new Integer(i).toString());
                    Attribute newAttribute = new Attribute(elemName, elem);
                    result.addAll(JmxUtil.getAttributeFragments(newAttribute));
                }
                return result;
            }
            catch (ClassCastException cc) {
                Array arrayval = (Array)value;
                for (int i = 0; i < Array.getLength(arrayval); ++i) {
                    Object elem = Array.get(arrayval, i);
                    String elemName = FragmentUtil.getNameForArrayElement(name, new Integer(i).toString());
                    Attribute newAttribute = new Attribute(elemName, elem);
                    result.addAll(JmxUtil.getAttributeFragments(newAttribute));
                }
                return result;
            }
        }
        throw new ComplexValuesException("Complex elements other then CompositeData, TabularData, Map, List, Array or Object[] are not supported");
    }
}

