/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.ValueType;
import com.conwet.silbops.util.JSONUtil;
import com.conwet.silbops.util.JSONizable;
import com.conwet.silbops.util.MultiValueMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class AdvFilter
implements JSONizable {
    private MultiValueMap<String, ValueType> attributes = new MultiValueMap();

    public void attribute(String attribute, ValueType valueType) {
        if (attribute == null || valueType == null) {
            throw new NullPointerException("Name or valueType are null: name=" + attribute + ", valueType=" + valueType);
        }
        this.attributes.add(attribute, valueType);
    }

    public Set<String> getAttributes() {
        return new HashSet<String>(this.attributes.keys());
    }

    public Collection<ValueType> getValueTypes(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public static AdvFilter fromJSON(JSONObject json) {
        AdvFilter advfilter = new AdvFilter();
        for (Object key : json.keySet()) {
            String attribute = (String)key;
            if (!(json.get(key) instanceof JSONArray)) {
                throw new IllegalArgumentException("Malformed object");
            }
            JSONArray valueTypes = (JSONArray)json.get(key);
            for (Object obj : valueTypes) {
                ValueType type = ValueType.fromJSON(JSONUtil.unboxString(obj));
                advfilter.attribute(attribute, type);
            }
        }
        return advfilter;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (String key : this.attributes.keys()) {
            JSONArray valueTypeJSON = new JSONArray();
            for (ValueType type : this.attributes.get(key)) {
                valueTypeJSON.add(type.toJSON());
            }
            json.put(key, valueTypeJSON);
        }
        return json;
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdvFilter) {
            AdvFilter other = (AdvFilter)obj;
            return this.attributes.equals(other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.attributes.hashCode();
        return hash;
    }
}

