/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.Constraint;
import com.conwet.silbops.model.Notification;
import com.conwet.silbops.model.OperatorType;
import com.conwet.silbops.model.Value;
import com.conwet.silbops.util.JSONizable;
import com.conwet.silbops.util.MultiValueMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Filter
implements JSONizable {
    private final MultiValueMap<String, Constraint> constraints = new MultiValueMap();

    public boolean match(Notification notification) {
        for (String constrainedAttribute : this.constraints.keys()) {
            if (Filter.matchAllConstraintsAtLeastOnce(this.constraints.get(constrainedAttribute), notification.getValues(constrainedAttribute))) continue;
            return false;
        }
        return true;
    }

    public ConstraintBuilder constrain(String attribute) {
        return new ConstraintBuilder(attribute);
    }

    public Set<String> attributes() {
        return this.constraints.keys();
    }

    public Set<MultiValueMap.Entry<String, Constraint>> entries() {
        return this.constraints.entries();
    }

    public String toString() {
        return this.constraints.toString();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        for (String attribute : this.attributes()) {
            Collection<Constraint> attrConstraints = this.constraints.get(attribute);
            if (attrConstraints.iterator().next().getType() == OperatorType.Exists) {
                json.put(attribute, new JSONArray());
                continue;
            }
            LinkedList<JSONObject> jsonAttrConstraints = new LinkedList<JSONObject>();
            for (Constraint attrConstraint : attrConstraints) {
                jsonAttrConstraints.add(attrConstraint.toJSON());
            }
            json.put(attribute, jsonAttrConstraints);
        }
        return json;
    }

    @Override
    public String toJSONString() {
        return this.toJSON().toJSONString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return this.constraints == other.constraints || this.constraints != null && this.constraints.equals(other.constraints);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.constraints != null ? this.constraints.hashCode() : 0);
        return hash;
    }

    public static Filter fromJSON(JSONObject json) {
        Filter filter = new Filter();
        for (String attribute : json.keySet()) {
            JSONArray constraints = (JSONArray)json.get(attribute);
            if (constraints.isEmpty()) {
                filter.constrain(attribute).exists();
                continue;
            }
            for (Object constraint : constraints.toArray()) {
                filter.addConstraint(attribute, Constraint.fromJSON((JSONObject)constraint));
            }
        }
        return filter;
    }

    private static boolean matchAllConstraintsAtLeastOnce(Collection<Constraint> constraints, Collection<Value> values) {
        for (Value value : values) {
            if (!Filter.matchAllConstraints(constraints, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchAllConstraints(Collection<Constraint> constraints, Value value) {
        for (Constraint constraint : constraints) {
            if (constraint.match(value)) continue;
            return false;
        }
        return true;
    }

    private void addConstraint(String attribute, Constraint constraint) {
        this.constraints.add(attribute, constraint);
    }

    public class ConstraintBuilder {
        private String attribute;

        private ConstraintBuilder(String attribute) {
            this.attribute = attribute;
        }

        public Filter filter() {
            return Filter.this;
        }

        public ConstraintBuilder constrain(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public ConstraintBuilder exists() {
            Filter.this.addConstraint(this.attribute, new Constraint());
            return this;
        }

        public ConstraintBuilder eq(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Eq, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder ne(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Ne, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder gt(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Gt, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder ge(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Ge, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder lt(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Lt, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder le(Object value) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Le, Value.fromObject(value)));
            return this;
        }

        public ConstraintBuilder startsWith(String prefix) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Prefix, new Value(prefix)));
            return this;
        }

        public ConstraintBuilder endsWith(String suffix) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Suffix, new Value(suffix)));
            return this;
        }

        public ConstraintBuilder contains(String string) {
            Filter.this.addConstraint(this.attribute, new Constraint(OperatorType.Contains, new Value(string)));
            return this;
        }
    }
}

