/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.silbops.model;

import com.conwet.silbops.model.Value;
import com.conwet.silbops.model.ValueType;
import com.conwet.silbops.util.JSONizable;
import org.json.simple.JSONValue;

public enum OperatorType implements JSONizable
{
    Exists,
    Eq,
    Ne,
    Gt,
    Ge,
    Lt,
    Le,
    Prefix,
    Suffix,
    Contains;


    public static OperatorType fromJSON(String str) {
        String camelCase = str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
        return OperatorType.valueOf(camelCase);
    }

    public boolean validOperand(Value value) {
        switch (this) {
            case Prefix: 
            case Suffix: 
            case Contains: {
                return value != null && value.getType() == ValueType.StringType;
            }
            case Exists: {
                return value == null;
            }
        }
        return value != null;
    }

    public String toString() {
        switch (this) {
            case Exists: {
                return "exists";
            }
            case Eq: {
                return "=";
            }
            case Ne: {
                return "!=";
            }
            case Gt: {
                return ">";
            }
            case Ge: {
                return ">=";
            }
            case Lt: {
                return "<";
            }
            case Le: {
                return "<=";
            }
            case Prefix: {
                return ">*";
            }
            case Suffix: {
                return "*<";
            }
            case Contains: {
                return "*";
            }
        }
        throw new IllegalStateException("Unhandled type");
    }

    @Override
    public String toJSON() {
        return this.name().toLowerCase();
    }

    @Override
    public String toJSONString() {
        return JSONValue.toJSONString(this.toJSON());
    }
}

