/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp;

import com.conwet.xjsp.features.DefaultXJSPHandler;
import com.conwet.xjsp.features.FeatureHandler;
import com.conwet.xjsp.features.SessionListener;
import com.conwet.xjsp.session.ConnectionContext;
import com.conwet.xjsp.session.ServerNegotiationState;
import com.conwet.xjsp.textstream.ConnectionHandler;
import com.conwet.xjsp.textstream.ConnectionHandlerFactory;
import com.conwet.xjsp.textstream.TextServer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XJSPServer
extends TextServer {
    private static final Logger logger = LoggerFactory.getLogger(XJSPServer.class);

    public XJSPServer(String host) throws IOException {
        this(host, 2222);
    }

    public XJSPServer(String host, int port) throws IOException {
        super(host, port, new ServerConnectionFactory());
        ((ServerConnectionFactory)this.getConnectionFactory()).addHandler("xjsp", new DefaultXJSPHandler());
        logger.info("XJSP server configured to listen on ({}:{})", (Object)host, (Object)port);
    }

    public void addHandler(FeatureHandler handler) {
        ((ServerConnectionFactory)this.getConnectionFactory()).addHandler(handler.getFeatureName(), handler);
    }

    public void addSessionListener(SessionListener listener) {
        ((ServerConnectionFactory)this.getConnectionFactory()).addSessionListener(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        ((ServerConnectionFactory)this.getConnectionFactory()).removeSessionListener(listener);
    }

    private static class ServerConnectionFactory
    implements ConnectionHandlerFactory {
        private final HashMap<String, FeatureHandler> handlers = new HashMap();
        private final List<SessionListener> sessionListeners = new LinkedList<SessionListener>();

        @Override
        public ConnectionHandler createConnectionHandler() {
            return new ConnectionContext(new ServerNegotiationState(this.handlers), this.sessionListeners);
        }

        private void addHandler(String prefix, FeatureHandler handler) {
            this.handlers.put(prefix, handler);
        }

        public void addSessionListener(SessionListener listener) {
            this.sessionListeners.add(listener);
        }

        public void removeSessionListener(SessionListener listener) {
            this.sessionListeners.remove(listener);
        }
    }
}

