/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.errors;

public enum ConnError {
    ProtocolSyntaxError(100, "Syntax error: %s"),
    NegotiationError(200, "Negotiation error: %s"),
    NegotiationFieldError(201, "Missing/Invalid field: %s"),
    UnavailableFeature(202, "Unavailable feature: %s"),
    NegotiationTimeout(203, "Negotiation aborted by timeout"),
    InvalidMessage(400, "Invalid message: %s"),
    MessageFieldError(401, "Missing/Invalid field: %s"),
    UnknownPrefix(402, "Unknown '%s' prefix"),
    MessageTimeout(403, "Message timeout"),
    ApplicationError(500, "Application error: %s");

    private final int code;
    private final String format;

    private ConnError(int code, String format) {
        this.code = code;
        this.format = format;
    }

    public String format(Object ... args) {
        return String.format(this.format, args);
    }

    public int getCode() {
        return this.code;
    }
}

