/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.session;

import com.conwet.xjsp.errors.ConnError;
import com.conwet.xjsp.errors.ConnectionException;
import com.conwet.xjsp.features.FeatureHandler;
import com.conwet.xjsp.features.FeatureMap;
import com.conwet.xjsp.features.ImmutableMessage;
import com.conwet.xjsp.features.Session;
import com.conwet.xjsp.features.SessionListener;
import com.conwet.xjsp.json.JSONUtil;
import com.conwet.xjsp.session.AbstractSession;
import com.conwet.xjsp.session.ClosingState;
import com.conwet.xjsp.session.ConnectionContext;
import com.conwet.xjsp.session.ConnectionState;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionState
implements ConnectionState {
    private static final Logger logger = LoggerFactory.getLogger(SessionState.class);
    private final FeatureMap features;
    private Session session;
    private boolean closed;

    public SessionState(FeatureMap features) {
        this.features = features;
        this.session = null;
        this.closed = false;
    }

    @Override
    public void start(final ConnectionContext context) throws ConnectionException {
        this.session = new AbstractSession(context.getChannel(), this.features){

            @Override
            public void close() {
                for (SessionListener listener : context.getSessionListeners()) {
                    listener.sessionCreated(SessionState.this.session);
                }
                SessionState.this.close(context);
            }
        };
        for (SessionListener listener : context.getSessionListeners()) {
            listener.sessionCreated(this.session);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void newData(ConnectionContext context) throws ConnectionException {
        JSONParser parser = new JSONParser();
        try {
            String stanza;
            while ((stanza = JSONUtil.extractStanza(context.getBuffer())) != null) {
                if ("]}".equals(stanza)) {
                    context.getChannel().sendFragment("]}");
                    context.dispose();
                    continue;
                }
                try {
                    JSONObject json = (JSONObject)parser.parse(stanza);
                    this.handleMessage(json, context);
                }
                catch (ParseException ex) {
                    throw new ConnectionException(ConnError.ProtocolSyntaxError, "Invalid stanza: " + ex.getMessage());
                    return;
                }
            }
        }
        catch (ParseException ex) {
            throw new ConnectionException(ConnError.ProtocolSyntaxError, ex.getMessage());
        }
    }

    @Override
    public long getTimeoutPeriod(ConnectionContext context) {
        if (context.getBuffer().toString().isEmpty()) {
            return 0L;
        }
        return 10000L;
    }

    @Override
    public void timeout(ConnectionContext context) throws ConnectionException {
        if (!context.getBuffer().toString().isEmpty()) {
            context.getBuffer().setLength(0);
            throw new ConnectionException(ConnError.MessageTimeout, new String[0]);
        }
    }

    private void handleMessage(JSONObject json, ConnectionContext context) throws ConnectionException {
        SessionState.hasFields(json, new String[]{"type", "id", "message"});
        String[] type = ((String)json.get("type")).split(":");
        if (type.length != 2) {
            throw new ConnectionException(ConnError.MessageFieldError, "type");
        }
        FeatureHandler feature = this.features.resolveFeature(type[0]);
        if (feature == null) {
            throw new ConnectionException(ConnError.UnknownPrefix, type[0]);
        }
        ImmutableMessage message = new ImmutableMessage(feature.getFeatureName(), type[1], json.get("message"), (String)json.get("id"));
        try {
            feature.handleMessage(message, this.session);
        }
        catch (Exception ex) {
            logger.warn("Application error when handling message", ex);
            throw new ConnectionException(ConnError.ApplicationError, ex.getMessage());
        }
    }

    private synchronized void close(ConnectionContext context) {
        if (!this.closed) {
            this.closed = true;
            context.setState(new ClosingState());
        }
    }

    private static void hasFields(JSONObject json, String[] keys) throws ConnectionException {
        for (String key : keys) {
            if (json.containsKey(key)) continue;
            throw new ConnectionException(ConnError.MessageFieldError, key);
        }
    }
}

