/*
 * Decompiled with CFR 0.152.
 */
package com.conwet.xjsp.textstream;

import com.conwet.xjsp.textstream.ConnectionHandler;
import com.conwet.xjsp.textstream.ConnectionHandlerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeoutSelectLoop
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutSelectLoop.class);
    private static final int BUFFER_SIZE = 1024;
    private final ByteBuffer rawBuffer = ByteBuffer.allocateDirect(1024);
    private final CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
    private final Map<SocketChannel, ConnectionHandler> sessions;
    private final Selector selector;
    private final ConnectionHandlerFactory factory;
    private boolean accepting;

    public TimeoutSelectLoop(Selector selector, ConnectionHandlerFactory factory) {
        this.selector = selector;
        this.factory = factory;
        this.accepting = true;
        this.sessions = new HashMap<SocketChannel, ConnectionHandler>();
    }

    @Override
    public void run() {
        Long closestTimeout = null;
        try {
            while (this.accepting) {
                int n = this.select(closestTimeout);
                long now = System.currentTimeMillis();
                if (n != 0) {
                    this.handleActiveSockets(now);
                }
                closestTimeout = this.handleTimeouts(now);
            }
        }
        catch (IOException ex) {
            logger.error("IO exception", ex);
        }
    }

    public void registerChannel(SocketChannel channel, ConnectionHandler handler) throws IOException {
        this.registerChannel(channel, handler, System.currentTimeMillis());
    }

    private int select(Long closestTimeout) throws IOException {
        long now = System.currentTimeMillis();
        long waiting = closestTimeout != null ? Math.max(closestTimeout - now, 0L) : 0L;
        return this.selector.select(waiting);
    }

    private Long handleTimeouts(long now) {
        Long closestTimeout = null;
        for (SelectionKey key : this.selector.keys()) {
            Long timeout;
            if (!(key.channel() instanceof SocketChannel) || (timeout = (Long)key.attachment()) == null) continue;
            if (timeout <= now) {
                SocketChannel channel = (SocketChannel)key.channel();
                ConnectionHandler handler = this.sessions.get(channel);
                if (handler == null) continue;
                handler.timeout();
                this.resetTimeout(key, now);
                continue;
            }
            if (closestTimeout != null && closestTimeout <= timeout) continue;
            closestTimeout = timeout;
        }
        return closestTimeout;
    }

    private void handleActiveSockets(long now) throws IOException {
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            if (key.isAcceptable()) {
                ServerSocketChannel server = (ServerSocketChannel)key.channel();
                SocketChannel channel = server.accept();
                ConnectionHandler handler = this.factory.createConnectionHandler();
                this.registerChannel(channel, handler, now);
            } else if (key.isReadable()) {
                SocketChannel channel = (SocketChannel)key.channel();
                String text = this.readData(channel);
                if (text != null) {
                    this.sessions.get(channel).newData(text);
                    this.resetTimeout(key, now);
                } else {
                    channel.close();
                    this.sessions.get(channel).dispose();
                    this.sessions.remove(channel);
                }
            }
            it.remove();
        }
    }

    private void resetTimeout(SelectionKey key, long now) {
        ConnectionHandler handler = this.sessions.get((SocketChannel)key.channel());
        long nextPeriod = handler.getTimeoutPeriod();
        if (nextPeriod > 0L) {
            key.attach(now + nextPeriod);
        } else {
            key.attach(null);
        }
    }

    private void registerChannel(SocketChannel channel, ConnectionHandler handler, long now) throws IOException {
        if (channel == null) {
            return;
        }
        channel.configureBlocking(false);
        channel.register(this.selector, 1);
        handler.setChannel(channel);
        handler.start();
        this.sessions.put(channel, handler);
        this.resetTimeout(channel.keyFor(this.selector), now);
    }

    private String readData(SocketChannel channel) {
        try {
            StringBuilder buffer = new StringBuilder();
            this.rawBuffer.clear();
            while (channel.read(this.rawBuffer) > 0) {
                this.rawBuffer.flip();
                buffer.append(this.decoder.decode(this.rawBuffer));
                this.rawBuffer.clear();
            }
            if (buffer.length() > 0) {
                return buffer.toString();
            }
            return null;
        }
        catch (IOException ex) {
            logger.error("IO exception", ex);
            return null;
        }
    }

    void stopSelecting() {
        this.accepting = false;
        this.selector.wakeup();
    }
}

