/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.probescheduler.internal;

import java.util.ArrayList;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.probescheduler.SchedulerException;
import org.ow2.jasmine.probe.probescheduler.SchedulerService;
import org.ow2.jasmine.probe.probescheduler.TaskReference;
import org.ow2.jasmine.probe.probescheduler.internal.Batch;
import org.ow2.jasmine.probe.probescheduler.internal.Clock;
import org.ow2.jasmine.probe.probescheduler.internal.TaskReferenceImpl;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

@Component(name="JasmineInternalScheduler")
@Provides
public class SchedulerServiceImpl
implements SchedulerService,
Pojo {
    private InstanceManager __IM;
    private boolean __Flogger;
    private Log logger;
    private static Batch batchThread;
    private static Clock clockThread;
    private static final long PERIOD_MAX = 30000L;
    private static final long PERIOD_MIN = 100L;
    private boolean __Fperiod;
    private long period;
    private boolean __Fminremtime;
    private long minremtime;
    private boolean __FtimerList;
    private ArrayList<TaskReferenceImpl> timerList;
    private boolean __FexpiredList;
    private ArrayList<TaskReferenceImpl> expiredList;
    private static boolean shuttingdown;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MschedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long;
    private boolean __Mclock;
    private boolean __Mbatch;

    Log __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Log)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Log log) {
        if (!this.__Flogger) {
            this.logger = log;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)log);
    }

    long __getperiod() {
        if (!this.__Fperiod) {
            return this.period;
        }
        Object object = this.__IM.onGet((Object)this, "period");
        Long l = (Long)object;
        return l;
    }

    void __setperiod(long l) {
        if (!this.__Fperiod) {
            this.period = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "period", (Object)l2);
    }

    long __getminremtime() {
        if (!this.__Fminremtime) {
            return this.minremtime;
        }
        Object object = this.__IM.onGet((Object)this, "minremtime");
        Long l = (Long)object;
        return l;
    }

    void __setminremtime(long l) {
        if (!this.__Fminremtime) {
            this.minremtime = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "minremtime", (Object)l2);
    }

    ArrayList __gettimerList() {
        if (!this.__FtimerList) {
            return this.timerList;
        }
        return (ArrayList)this.__IM.onGet((Object)this, "timerList");
    }

    void __settimerList(ArrayList arrayList) {
        if (!this.__FtimerList) {
            this.timerList = arrayList;
            return;
        }
        this.__IM.onSet((Object)this, "timerList", (Object)arrayList);
    }

    ArrayList __getexpiredList() {
        if (!this.__FexpiredList) {
            return this.expiredList;
        }
        return (ArrayList)this.__IM.onGet((Object)this, "expiredList");
    }

    void __setexpiredList(ArrayList arrayList) {
        if (!this.__FexpiredList) {
            this.expiredList = arrayList;
            return;
        }
        this.__IM.onSet((Object)this, "expiredList", (Object)arrayList);
    }

    public SchedulerServiceImpl() {
        this(null);
    }

    private SchedulerServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setlogger(LogFactory.getLog(SchedulerService.class));
        this.__setminremtime(30000L);
        this.__settimerList(new ArrayList());
        this.__setexpiredList(new ArrayList());
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__getlogger().debug((Object)"", new Object[0]);
        batchThread = new Batch(this);
        batchThread.start();
        clockThread = new Clock(this);
        clockThread.start();
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.__getlogger().debug((Object)"", new Object[0]);
    }

    public TaskReference schedulePeriodicTask(String string, Runnable runnable, long l, long l2) throws SchedulerException {
        TaskReference taskReference;
        if (!this.__MschedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long) {
            return this.__schedulePeriodicTask(string, runnable, l, l2);
        }
        try {
            Object[] objectArray = new Object[4];
            objectArray[0] = string;
            objectArray[1] = runnable;
            objectArray[2] = new Long(l);
            objectArray[3] = new Long(l2);
            this.__IM.onEntry((Object)this, "schedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long", objectArray);
            taskReference = this.__schedulePeriodicTask(string, runnable, l, l2);
            this.__IM.onExit((Object)this, "schedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long", (Object)taskReference);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "schedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long", throwable);
            throw throwable;
        }
        return taskReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskReference __schedulePeriodicTask(String name, Runnable task, long initialDelay, long period) throws SchedulerException {
        this.__getlogger().debug((Object)"", new Object[0]);
        TaskReferenceImpl timer = new TaskReferenceImpl(task, period, true);
        ArrayList arrayList = this.__gettimerList();
        synchronized (arrayList) {
            this.__gettimerList().add(timer);
            if (period < this.__getminremtime()) {
                this.__setminremtime(period);
            }
            this.__gettimerList().notifyAll();
        }
        return timer;
    }

    public void clock() {
        if (!this.__Mclock) {
            this.__clock();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "clock", new Object[0]);
            this.__clock();
            this.__IM.onExit((Object)this, "clock", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "clock", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __clock() {
        ArrayList arrayList = this.__gettimerList();
        synchronized (arrayList) {
            while (true) {
                if (shuttingdown) {
                    this.__setperiod(1L);
                } else {
                    this.__setperiod(30000L);
                    if (this.__getminremtime() < this.__getperiod()) {
                        this.__setperiod(this.__getminremtime() < 100L ? 100L : this.__getminremtime());
                    }
                }
                try {
                    this.__gettimerList().wait(this.__getperiod());
                }
                catch (InterruptedException e) {
                    this.__getlogger().error((Object)"Timer interrupted", new Object[0]);
                }
                int found = 0;
                boolean empty = true;
                this.__setminremtime(30000L);
                ArrayList<TaskReferenceImpl> toremove = new ArrayList<TaskReferenceImpl>();
                for (TaskReferenceImpl t : this.__gettimerList()) {
                    long remtime;
                    if (!t.isStopped()) {
                        empty = false;
                    }
                    if ((remtime = t.update()) <= 0L) {
                        if (t.valid()) {
                            this.__getexpiredList().add(t);
                            ++found;
                            if (t.ispermanent() && !shuttingdown) {
                                remtime = t.restart();
                                if (remtime < this.__getminremtime()) {
                                    this.__setminremtime(remtime);
                                }
                            } else {
                                toremove.add(t);
                            }
                        } else {
                            toremove.add(t);
                        }
                    } else if (remtime < this.__getminremtime()) {
                        this.__setminremtime(remtime);
                    }
                    t = null;
                }
                for (TaskReferenceImpl t : toremove) {
                    this.__gettimerList().remove(t);
                }
                if (found > 0) {
                    this.__gettimerList().notifyAll();
                    continue;
                }
                if (empty && shuttingdown) break;
            }
            this.__gettimerList().notifyAll();
        }
    }

    public void batch() {
        if (!this.__Mbatch) {
            this.__batch();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "batch", new Object[0]);
            this.__batch();
            this.__IM.onExit((Object)this, "batch", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "batch", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __batch() {
        while (!(shuttingdown && this.__gettimerList().isEmpty() && this.__getexpiredList().isEmpty())) {
            TaskReferenceImpl t;
            ArrayList arrayList = this.__gettimerList();
            synchronized (arrayList) {
                while (this.__getexpiredList().isEmpty()) {
                    if (shuttingdown) {
                        this.__getlogger().warn((Object)"TimerManager shutting down", new Object[0]);
                        return;
                    }
                    try {
                        this.__gettimerList().wait();
                    }
                    catch (Exception e) {
                        this.__getlogger().error((Object)"Exception in Batch: ", new Object[]{e});
                    }
                }
                t = (TaskReferenceImpl)this.__getexpiredList().remove(0);
            }
            try {
                t.process();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                this.__getlogger().warn((Object)"Ignoring null pointer exception", new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.__getlogger().warn((Object)("Ignoring exception: " + e), new Object[0]);
            }
        }
        this.__getlogger().info((Object)"TimerManager stopped", new Object[0]);
    }

    static {
        shuttingdown = false;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("timerList")) {
                this.__FtimerList = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("expiredList")) {
                this.__FexpiredList = true;
            }
            if (set.contains("period")) {
                this.__Fperiod = true;
            }
            if (set.contains("minremtime")) {
                this.__Fminremtime = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("schedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long")) {
                this.__MschedulePeriodicTask$java_lang_String$java_lang_Runnable$long$long = true;
            }
            if (set.contains("clock")) {
                this.__Mclock = true;
            }
            if (set.contains("batch")) {
                this.__Mbatch = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

