/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.aggregate.internal;

import java.util.Collection;
import java.util.HashMap;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineAggregateService;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class JAggregateCollector
extends JCollector {
    private int ope;
    private String operation;
    public static final int OP_MIN = 1;
    public static final int OP_MAX = 2;
    public static final int OP_SUM = 3;
    public static final int OP_AVERAGE = 4;
    private JasmineCollector source = null;
    private String merged;

    public JAggregateCollector(String probeId, JasmineIndicator def, int period, String operation, JasmineCollector source, String merged) {
        super(probeId, def, period);
        this.operation = operation;
        this.ope = 0;
        if (operation.equalsIgnoreCase("min")) {
            this.ope = 1;
        } else if (operation.equalsIgnoreCase("max")) {
            this.ope = 2;
        } else if (operation.equalsIgnoreCase("sum")) {
            this.ope = 3;
        } else if (operation.equalsIgnoreCase("average")) {
            this.ope = 4;
        }
        this.source = source;
        this.merged = merged;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue current = this.source.getLastResult();
        if (current == null) {
            this.logger.warn((Object)"No result available on source indicator {0}", new Object[]{this.source.getIndicatorName()});
            return null;
        }
        JasmineAggregateService aggserv = this.probeManager.getAggregate(this.operation);
        if (aggserv != null) {
            return aggserv.aggregate(current);
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        for (String key : current.getMetadata().keySet()) {
            jiv.addMetadata(key, (String)current.getMetadata().get(key));
        }
        jiv.setTarget(current.getTarget());
        Collection jsrs = current.getValues();
        HashMap jsrProps = this.jsrProps(jsrs);
        JasmineSingleNumberResult jsrm = new JasmineSingleNumberResult();
        Number resval = null;
        switch (this.ope) {
            case 2: {
                resval = this.maxJsr(jsrs);
                break;
            }
            case 1: {
                resval = this.minJsr(jsrs);
                break;
            }
            case 3: {
                resval = this.addJsr(jsrs);
                break;
            }
            case 4: {
                resval = this.averageJsr(jsrs);
                break;
            }
            default: {
                throw new JasmineCollectorException("Unimplemented merge operation " + this.ope);
            }
        }
        jsrm.setName("");
        jsrm.setTimestamp(current.getTimestamp());
        jsrm.setValue((Object)resval);
        jsrm.setProperties(jsrProps);
        jiv.addValue((JasmineSingleResult)jsrm);
        jiv.setMultiValue(false);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.source.stopPolling();
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.source.startPolling();
    }
}

