/**
 * JASMINe
 * Copyright (C) 2011-2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ConstantCollector.java 9826 2012-02-10 10:09:33Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors.constant;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

import java.util.Map;

/**
 */
public class ConstantCollector extends JCollector {

    private String type;
    private String value;
    private Number number;

    /**
     * Constructor
     * @param indicator definition
     */
    public ConstantCollector(String probeId, JasmineIndicator indicator, int period) {
        super(probeId, indicator, period);
        Map<String, String> props = indicator.getProperties();
        type = props.get("type");
        value = props.get("value");
        if (type.equalsIgnoreCase("int")) {
            number = Integer.parseInt(value);
        } else if (type.equalsIgnoreCase("long")) {
            number = Long.parseLong(value);
        } else if (type.equalsIgnoreCase("float")) {
            number = Float.valueOf(value);
        } else if (type.equalsIgnoreCase("double")) {
            number = Double.valueOf(value);
        }
    }

    // ----------------------------------------------------------
    // JasmineCollector implementation
    // ----------------------------------------------------------

    /**
     * Retrieve the last results for this indicator
     * This method return a List of results in case indicator represents
     * actually a list of value
     * @return List of JasmineIndicatorValue
     */
    @Override
    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        logger.debug("");

        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        JasmineSingleResult jsr = new JasmineSingleNumberResult();
        jsr.setName(value);
        jsr.setTimestamp(System.currentTimeMillis());
        jsr.setValue(number);
        jiv.setName(indicator.getName());
        jiv.addValue(jsr);
        jiv.setMultiValue(false);
        return jiv;
    }

    /**
     * Stop polling
     */
    public void stopPolling() {
        logger.debug("Stop polling");
    }

    /**
     * Restart polling
     */
    public void startPolling() {
        logger.debug("Start polling");
    }

}
