/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DerivedIndicatorParams.java 8733 2011-08-10 09:51:06Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors.derived.shell;

import java.util.ArrayList;
import java.util.List;

import com.beust.jcommander.Parameter;
import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

/**
 * Describes params for derived indicator commands
 * @author durieuxp
 */
public class DerivedIndicatorParams extends JasmineProbeCommandParams {

    @Parameter(names = { "-n", "--name" }, description = "Name of the indicator to create", required = true)
    public String name = null;

    public String getName() {
        return name;
    }

    @Parameter(names = { "-o", "--operation" }, description = "Derived operation (prev|delta|rate)", required = true)
    private String op;

    public String getOp() {
        return op;
    }

    @Parameter(names = { "-s", "--source" }, description = "Source indicator name", required = true)
    private String source;

    public String getSource() {
        return source;
    }

    public void reset() {
        name = null;
        op = null;
        source = null;
    }
}
