/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.derived.internal;

import java.util.HashMap;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class DerivedCollector
extends JCollector {
    private int ope;
    private String operation;
    private JasmineCollector source;
    private JasmineIndicatorValue previous = null;

    public DerivedCollector(String name, JasmineIndicator indic, int period, String op, JasmineCollector source) {
        super(name, indic, period);
        this.operation = op;
        if (this.operation.equalsIgnoreCase("prev")) {
            this.ope = 1;
        } else if (this.operation.equalsIgnoreCase("delta")) {
            this.ope = 2;
        } else if (this.operation.equalsIgnoreCase("rate")) {
            this.ope = 3;
        } else {
            String err = "Operation not supported in DerivedCollectorService: " + this.operation;
            this.logger.error((Object)err, new Object[0]);
            return;
        }
        this.source = source;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue current = this.source.getLastResult();
        if (this.previous == null) {
            this.previous = current;
            this.logger.debug((Object)"First call: No previous value yet", new Object[0]);
            return null;
        }
        long curtime = current.getTimestamp();
        long timeslice = curtime - this.previous.getTimestamp();
        if (timeslice < 1000L) {
            this.logger.debug((Object)"No recent value.", new Object[0]);
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        jiv.addMetadata("op", this.operation);
        for (String key : current.getMetadata().keySet()) {
            if (key.equals("op")) continue;
            jiv.addMetadata(key, (String)current.getMetadata().get(key));
        }
        jiv.setTarget(current.getTarget());
        for (JasmineSingleResult res : current.getValues()) {
            JasmineSingleResult old = this.previous.getValue(res.getName());
            JasmineSingleNumberResult val = new JasmineSingleNumberResult();
            String name = this.indicator.getName();
            if (current.getValues().size() > 1) {
                name = name + "(" + res.getName() + ")";
            }
            val.setName(name);
            val.setTimestamp(curtime);
            HashMap resProps = res.getProperties();
            if (!resProps.isEmpty()) {
                for (String propKey : resProps.keySet()) {
                    String propVal = (String)resProps.get(propKey);
                    val.addProperty(propKey, propVal);
                    this.logger.warn((Object)"Add source value property {0} to the derived value {1}", new Object[]{propKey, name});
                }
            }
            Number value = null;
            switch (this.ope) {
                case 1: {
                    value = (Number)old.getValue();
                    if (this.indicator.getScale() != 1) {
                        value = Float.valueOf(this.divideValues(value, this.indicator.getScale()));
                    }
                    val.setValue((Object)value);
                    break;
                }
                case 2: {
                    value = this.diffValues((Number)res.getValue(), (Number)old.getValue());
                    if (this.indicator.getScale() != 1) {
                        value = Float.valueOf(this.divideValues(value, this.indicator.getScale()));
                    }
                    val.setValue((Object)value);
                    break;
                }
                case 3: {
                    long diff = this.diffValues((Number)res.getValue(), (Number)old.getValue());
                    float rate = 1000L * diff / timeslice;
                    if (this.indicator.getScale() != 1) {
                        rate /= (float)this.indicator.getScale();
                    }
                    val.setValue((Object)Float.valueOf(rate));
                    break;
                }
                default: {
                    throw new JasmineCollectorException("Unimplemented derived operation " + this.ope);
                }
            }
            jiv.addValue((JasmineSingleResult)val);
        }
        this.previous = current;
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.previous = null;
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

