/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.derived.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class DerivedCollector
extends JCollector {
    private int ope;
    private String operation;
    private JasmineCollector source;
    private JasmineIndicatorValue previous = null;

    public DerivedCollector(String probeId, JasmineIndicator indic, int period, String op, JasmineCollector source) {
        super(probeId, indic, period);
        this.operation = op;
        if (this.operation.equalsIgnoreCase("prev")) {
            this.ope = 1;
        } else if (this.operation.equalsIgnoreCase("delta")) {
            this.ope = 2;
        } else if (this.operation.equalsIgnoreCase("rate")) {
            this.ope = 3;
        } else {
            String err = "Operation not supported in DerivedCollectorService: " + this.operation;
            this.logger.error((Object)err, new Object[0]);
            return;
        }
        this.source = source;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue current = this.source.getLastResult();
        if (current == null) {
            this.logger.warn((Object)"No result available on source indicator {0}", new Object[]{this.source.getIndicatorName()});
            return null;
        }
        if (this.previous == null) {
            this.previous = current;
            this.logger.warn((Object)"First call: No previous value yet for indicator {0} in probe {1}", new Object[]{this.getIndicatorName(), this.probeId});
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(this.indicator.getName());
        for (String key : current.getMetadata().keySet()) {
            jiv.addMetadata(key, (String)current.getMetadata().get(key));
        }
        jiv.setTarget(current.getTarget());
        jiv.setMultiValue(current.isMultiValue());
        for (JasmineSingleResult currentResult : current.getValues()) {
            JasmineSingleResult newRes = this.getDerivedResult(currentResult);
            newRes.setName(currentResult.getName());
            jiv.addValue(newRes);
        }
        this.previous = current;
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.source.stopPolling();
        this.previous = null;
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.source.startPolling();
    }

    private JasmineSingleResult getDerivedResult(JasmineSingleResult currentResult) throws JasmineCollectorException {
        JasmineSingleResult previousResult;
        this.logger.debug((Object)"Compute derived result for {0} of indicator {1}", new Object[]{currentResult.getName(), this.getIndicatorName()});
        JasmineSingleNumberResult result = new JasmineSingleNumberResult();
        result.setTimestamp(currentResult.getTimestamp());
        HashMap resProps = currentResult.getProperties();
        if (!resProps.isEmpty()) {
            for (String propKey : resProps.keySet()) {
                String propVal = (String)resProps.get(propKey);
                result.addProperty(propKey, propVal);
                this.logger.debug((Object)"Add source result property {0} to the derived result {1}", new Object[]{propKey, result.getName()});
            }
        }
        if ((previousResult = this.getPreviousResult(currentResult)) == null) {
            result.setValue(null);
            return result;
        }
        Number value = null;
        switch (this.ope) {
            case 1: {
                value = (Number)previousResult.getValue();
                break;
            }
            case 2: {
                value = this.diffValues((Number)currentResult.getValue(), (Number)previousResult.getValue());
                this.logger.debug((Object)"Compute delta of {0} - {1}", new Object[]{currentResult.getValue(), previousResult.getValue()});
                break;
            }
            case 3: {
                Number diff = this.diffValues((Number)currentResult.getValue(), (Number)previousResult.getValue());
                long timeslice = currentResult.getTimestamp() - previousResult.getTimestamp();
                long timeSliceInSeconds = TimeUnit.MILLISECONDS.toSeconds(timeslice);
                value = this.divideValues(diff, timeSliceInSeconds).doubleValue();
                this.logger.debug((Object)"Compute rate for current value {0} and previous value {1} and timeslice {2}. Result is {3}", new Object[]{currentResult.getValue(), previousResult.getValue(), timeSliceInSeconds, value});
                break;
            }
            default: {
                throw new JasmineCollectorException("Unimplemented derived operation " + this.ope);
            }
        }
        if (this.indicator.getScale() != 1) {
            value = this.divideValues(value, this.indicator.getScale());
        }
        result.setValue((Object)value);
        return result;
    }

    private JasmineSingleResult getPreviousResult(JasmineSingleResult currentResult) throws JasmineCollectorException {
        if (this.previous == null) {
            return null;
        }
        ArrayList<JasmineSingleResult> possiblePrevResults = new ArrayList<JasmineSingleResult>();
        for (JasmineSingleResult prevResult : this.previous.getValues()) {
            if (!prevResult.getName().equals(currentResult.getName())) continue;
            possiblePrevResults.add(prevResult);
        }
        if (possiblePrevResults.size() == 1) {
            this.logger.debug((Object)"Directly found previous value of indicator {0} result {1} ", new Object[]{this.getIndicatorName(), currentResult.getName()});
            return (JasmineSingleResult)possiblePrevResults.get(0);
        }
        HashMap resProps = currentResult.getProperties();
        if (resProps.isEmpty()) {
            throw new JasmineCollectorException("Could not found the corresponding previous value for result " + currentResult.getName() + " in indicator " + this.getIndicatorName());
        }
        for (JasmineSingleResult prevResult : possiblePrevResults) {
            boolean okPrevResult = true;
            HashMap prevResultProps = prevResult.getProperties();
            for (String propKey : resProps.keySet()) {
                String prevPropVal;
                String propVal;
                if (!prevResultProps.containsKey(propKey) || (propVal = (String)resProps.get(propKey)).equals(prevPropVal = (String)prevResultProps.get(propKey))) continue;
                okPrevResult = false;
            }
            if (!okPrevResult) continue;
            this.logger.debug((Object)"Found previous value of indicator {0} result {1} based on metadata matching", new Object[]{this.getIndicatorName(), currentResult.getName()});
            this.logger.debug((Object)"Prev result: ", new Object[]{prevResult.toString()});
            this.logger.debug((Object)"Current result: ", new Object[]{currentResult.toString()});
            return prevResult;
        }
        throw new JasmineCollectorException("Could not found the corresponding previous value for result " + currentResult.getName() + " in indicator " + this.getIndicatorName());
    }
}

