/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DfIndicatorParams.java 8745 2011-08-12 09:20:52Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors.df.shell;

import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

import com.beust.jcommander.Parameter;

public class DfIndicatorParams extends JasmineProbeCommandParams {

    @Parameter(names = { "-n", "--name" }, description = "Name of the indicator to create", required = true)
    public String name = null;

    @Parameter(names = { "-d", "--disk" }, description = "Disk name", required = false)
    private String disk;

    @Parameter(names = { "-s", "--scale" }, description = "Scale for indicator values", required = false)
    public int scale = 1;

    public String getName() {
        return name;
    }

    public String getDisk() {
        return disk;
    }

    public int getScale() {
        return scale;
    }

    public void reset() {
        name = null;
        disk = null;
        scale = 1;
    }

}

