/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DfIndicatorCreateCommand.java 8738 2011-08-11 10:34:30Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors.df.shell;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.shell.Command;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineProbeManager;
import org.ow2.jasmine.probe.collectors.df.internal.DfCollectorService;
import org.ow2.jasmine.probe.shell.JasmineProbeCommand;

@Component(name="DfIndicatorCreateCommand")
@Provides
public class DfIndicatorCreateCommand extends JasmineProbeCommand implements Command {

    /**
     * Type of indicator
     * Must be equal to : DfCollectorService.indicatorType
     */
    private final static String indicatorType = "df";

    /**
     * command name
     */
    private String name = "indicator-df-create";

    /**
     * necessary to be able to print out usage even when wrong options are provided by the user
     */
    private String requiredOptions = "-n indicatorName -d diskName";

    /**
     * command description
     */
    private String description = "Create a df type Indicator";


    // ----------------------------------------------------------------------------
    // ipojo management
    // ----------------------------------------------------------------------------

    @Requires
    JasmineProbeManager probeManager = null;

    // ----------------------------------------------------------------------------
    // constructors
    // ----------------------------------------------------------------------------

    /**
     * Default Constructor
     */
    public DfIndicatorCreateCommand() {
        super();
        setParams(new DfIndicatorParams());
    }

    // ----------------------------------------------------------------------------
    // org.apache.felix.shell.Command implementation
    // ----------------------------------------------------------------------------

    /**
     * Returns the name of the command that is implemented by the interface.
     * The command name should not contain whitespace and should also be unique.
     * @return the name of the command.
     */
    public String getName() {
        return name;
    }

    /**
     * Returns a short description of the command; this description should be as short as possible.
     * This information is used when generating the command help information.
     * @return a short description of the command.
     */
    public String getShortDescription() {
        return description;
    }

    public String getRequiredOptions() {
        return requiredOptions;
    }

    public JasmineProbeManager getProbeManager() {
        return probeManager;
    }

    /**
     * Executes the command using the supplied command line, output print stream, and error print stream.
     * @param line the complete command line, including the command name.
     * @param out  the print stream to use for standard output.
     * @param err  the print stream to use for standard error.
     */
    public void execute(String line, PrintStream out, PrintStream err) {
        boolean validOptions = parseOptions(line, out, err);
        if (!validOptions) {
            err.println(getUsage());
            return;
        }

        DfIndicatorParams params = (DfIndicatorParams) getParams();

        // Create a JasmineIndicator object and initialize it with command line parameters
        JasmineIndicator indicator = new JasmineIndicator();
        indicator.setName(params.getName());
        indicator.setType(indicatorType);
        // set the rest of the properties
        Map<String, String> properties =  new HashMap<String, String>();
        String diskName = params.getDisk();
        if (diskName != null) {
            properties.put(DfCollectorService.PROP_DISK, params.getDisk());
        }
        indicator.setProperties(properties);

        // reset params
        params.reset();

        // Create the JasmineIndicator
        createIndicator(name, indicator, out, err);
    }
}
