/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.df.internal;

import java.util.Collection;
import java.util.Map;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.util.CsvConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfCollector
extends JCollector {
    private Collection<String> diskList = null;
    private JasmineIndicatorValue cache = null;
    private static final long OBSOLATE_TIME = 3000L;
    private boolean stopped = false;

    public DfCollector(String name, JasmineIndicator indicator, int period) {
        super(name, indicator, period);
        Map props = indicator.getProperties();
        this.diskList = CsvConverter.csv2list((String)((String)props.get("disk")));
    }

    public Collection<String> getDiskList() {
        return this.diskList;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        JasmineIndicatorValue jiv = this.cache;
        this.logger.debug((Object)("value=" + jiv), new Object[0]);
        if (this.indicator.getScale() != 1) {
            for (JasmineSingleResult jsr : jiv.getValues()) {
                long value = this.longValue((Number)jsr.getValue()) / (long)this.indicator.getScale();
                jsr.setValue((Object)value);
            }
        }
        jiv.addMetadata("server", this.getServerName());
        jiv.addMetadata("domain", this.getDomainName());
        if (this.hostName != null) {
            jiv.setTarget(this.hostName);
        } else {
            jiv.setTarget(this.getServerName());
        }
        this.cache = null;
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.stopped = true;
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
        this.stopped = false;
    }

    public boolean needResult() {
        if (this.stopped) {
            return false;
        }
        if (this.cache == null) {
            return true;
        }
        long timestamp = this.cache.getTimestamp();
        if (this.oldvalue(timestamp)) {
            this.cache = null;
            return true;
        }
        return false;
    }

    public void addResult(JasmineIndicatorValue value) {
        this.logger.debug((Object)value.getName(), new Object[0]);
        this.cache = value;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000) + 3000L;
    }
}

