/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Metric.java 8591 2011-07-20 11:58:18Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors.jmx;

import javax.management.AttributeList;
import javax.management.ObjectName;

/**
 * This Value Object holds the result of a collect for a given mbean
 * @author durieuxp
 */
public class Metric {

    /**
     * Metric timestamp
     */
    private long timestamp = 0;

    /**
     * ObjectName of the Mbean
     */
    private ObjectName mbean = null;

    /**
     * Attribute list
     */
    private AttributeList attributes = null;

    private String target;

    /**
     * Constructor
     * @param t
     * @param mbean
     * @param attl
     * @param target
     */
    public Metric(Long t, ObjectName mbean, AttributeList attl, String target) {
        this.timestamp = t;
        this.mbean = mbean;
        this.attributes = attl;
        this.target = target;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public ObjectName getMBean() {
        return mbean;
    }

    public AttributeList getAttributeList() {
        return attributes;
    }

    public String getTarget() {
        return target;
    }

    public String toString() {
        return target + ":" + mbean + ":" + attributes.toString();
    }

}
