/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmxIndicatorParams.java 8661 2011-07-26 09:04:24Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors.jmx.shell;

import java.util.ArrayList;
import java.util.List;

import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

import com.beust.jcommander.Parameter;

public class JmxIndicatorParams extends JasmineProbeCommandParams {

    @Parameter(description = "Indicator name")
    public List<String> name = new ArrayList<String>();

    @Parameter(names = { "-t", "--target" }, description = "Target name", required = false)
    private String target;

    @Parameter(names = { "-m", "--mbean" }, description = "MBean filter", required = false)
    private String mbean;

    @Parameter(names = { "-a", "--attr" }, description = "Attributes list", required = false)
    private String attr;

    public void reset() {
        name.clear();
        target = null;
        mbean = null;
        attr = null;
    }

    public String getName() {
        return name.get(0);
    }

    public String getTarget() {
        return target;
    }

    public String getMbean() {
        return mbean;
    }

    public String getAttr() {
        return attr;
    }

}

