/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collectors.JCollector;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxWorker
extends Thread {
    private Log logger = LogFactory.getLog(JCollector.class);
    private boolean started = false;
    private String targetname;
    private String url;
    private long collectorTimeout = 1000L;
    private static final long DEFAULT_TIMEOUT = 1000L;
    private Collection<JmxCollector> collectors = new ArrayList<JmxCollector>();
    private JmxConnectionService jmxService;
    private Map<String, Object> env = new HashMap<String, Object>();
    private JmxConnectionFactory cfactory = null;
    private String serverName = null;
    private String domainName = null;

    public JmxWorker(JasmineTarget target, JmxConnectionService jmxConnectionService) {
        this.logger.debug((Object)target.getName(), new Object[0]);
        this.targetname = target.getName();
        this.url = target.getUrl();
        this.jmxService = jmxConnectionService;
    }

    public synchronized void remove() {
        this.started = false;
    }

    public synchronized void addCollector(JmxCollector col) {
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            ArrayList<JmxCollector> topoll = new ArrayList<JmxCollector>();
            JmxWorker jmxWorker = this;
            synchronized (jmxWorker) {
                for (JmxCollector coll : this.collectors) {
                    if (!coll.needResult()) continue;
                    topoll.add(coll);
                }
            }
            if (!topoll.isEmpty()) {
                long t = System.currentTimeMillis();
                MBeanServerConnection cnx = null;
                try {
                    cnx = this.getMBeanServerConnection();
                }
                catch (JmxConnectionException e) {
                    this.logger.warn((Object)("Cannot get Jmx Access:" + (Object)((Object)e)), new Object[0]);
                }
                if (cnx != null) {
                    if (this.serverName == null || this.domainName == null) {
                        this.setServerAndDomain(cnx);
                    }
                    for (JmxCollector coll : topoll) {
                        List<Metric> metrics = this.collect(cnx, coll);
                        coll.addResult(metrics);
                    }
                }
            }
            jmxWorker = this;
            synchronized (jmxWorker) {
                try {
                    this.wait(this.collectorTimeout);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        if (this.cfactory == null) {
            this.cfactory = this.jmxService.getJmxConnectionFactory(this.url, this.env);
        }
        return this.cfactory.getMBeanServerConnection();
    }

    private void setServerAndDomain(MBeanServerConnection cnx) {
        try {
            ObjectName j2eeinstance = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
            Iterator<ObjectName> onames = cnx.queryNames(j2eeinstance, null).iterator();
            ObjectName serverOn = onames.next();
            this.serverName = (String)cnx.getAttribute(serverOn, "serverName");
            this.domainName = serverOn.getDomain();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot get server and domain names for target ", new Object[]{this.targetname});
        }
    }

    private List<Metric> collect(MBeanServerConnection cnx, JmxCollector col) {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        try {
            ObjectName objname = col.getObjectName();
            if (objname.isPattern()) {
                this.logger.debug((Object)("pattern:" + objname.toString()), new Object[0]);
                Set<ObjectName> onset = cnx.queryNames(objname, null);
                for (ObjectName mbean : onset) {
                    this.logger.debug((Object)("mbean:" + mbean.toString()), new Object[0]);
                    long time = System.currentTimeMillis();
                    AttributeList attl = cnx.getAttributes(mbean, col.getAttributes());
                    metrics.add(new Metric(time, mbean, attl, this.targetname));
                }
            } else {
                this.logger.debug((Object)("single mbean:" + objname.toString()), new Object[0]);
                long time = System.currentTimeMillis();
                AttributeList attl = cnx.getAttributes(objname, col.getAttributes());
                metrics.add(new Metric(time, objname, attl, this.targetname));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("getAttributes error on JmxServer: " + e), new Object[0]);
        }
        this.logger.debug((Object)("nb of metrics found: " + metrics.size()), new Object[0]);
        return metrics;
    }
}

