/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: FragmentNameException.java 8752 2011-08-23 13:41:59Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import org.ow2.jasmine.probe.JasmineProbeException;

/**
 * Exceptions related to the naming policy of the attribute fragments.
 *
 * Attribute fragments are elements of complex attributes.
 *
 * Sometimes, users need to poll such attribute elements, for example an item in a Map,
 * and don't need the entire attribute value.
 * A naming policy is necessary to define the attributes elements to be polled by a JMX indicator.
 *
 * Also, when a JMX indicator specifies an attribute (or an attribute fragment) whose value has a complex
 * type, the value must be decomposed in simple elements (elementary fragments).
 * The naming policy is used to identify the fragments returned by a probe polling this indicator.
 *
 * @author danesa
 */
public class FragmentNameException extends JasmineProbeException {

    public FragmentNameException(String message) {
        super(message);
    }

    /**
     *
     */
    private static final long serialVersionUID = 1L;

}
