/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxProxy {
    private Log logger = LogFactory.getLog(JmxProxy.class);
    private JmxConnectionService jmxConnectionService = null;
    private JmxConnectionFactory cfactory = null;
    private MBeanServerConnection cnx = null;
    private JasmineTarget target = null;
    private Map<String, String> targetProps = new HashMap<String, String>();
    private String targetUrl;
    private String serverName = null;
    private String domainName = null;
    private boolean serverNameSet = false;
    private String error;

    public JmxConnectionService getJmxConnectionService() {
        return this.jmxConnectionService;
    }

    public void setJmxConnectionService(JmxConnectionService jmxConnectionService) {
        this.jmxConnectionService = jmxConnectionService;
    }

    public JasmineTarget getTarget() {
        return this.target;
    }

    public void setTarget(JasmineTarget target) {
        this.target = target;
        this.targetProps = target.getProperties();
        this.targetUrl = this.targetProps.get("url");
    }

    protected List<Metric> collectMetrics(ObjectName objname, String indicatorName, List<String> names) throws JmxConnectionException {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        try {
            MBeanServerConnection cnx = this.getMBeanServerConnection();
            Set<ObjectName> onset = null;
            if (objname.isPattern()) {
                this.logger.debug((Object)("collect pattern:" + objname.toString()), new Object[0]);
                try {
                    onset = JmxUtil.getMBeans(cnx, objname);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.logger.debug((Object)("collect single mbean:" + objname.toString()), new Object[0]);
                try {
                    if (cnx.isRegistered(objname)) {
                        onset = new HashSet<ObjectName>();
                        onset.add(objname);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            for (ObjectName on : onset) {
                Metric m = this.collectMBeanMetric(cnx, on, indicatorName, names);
                if (m == null) continue;
                this.setMultiValue(names, m);
                metrics.add(m);
            }
        }
        catch (JmxConnectionException e) {
            this.logger.warn((Object)"Cannot get Jmx access to target {0} with url {1} - {2}", new Object[]{this.target.getName(), this.targetUrl, e.getMessage()});
            throw e;
        }
        return metrics;
    }

    private Metric collectMBeanMetric(MBeanServerConnection cnx, ObjectName objname, String indicatorName, List<String> names) throws JmxConnectionException {
        this.logger.debug((Object)("mbean:" + objname.toString()), new Object[0]);
        AttributeList attl = new AttributeList();
        Metric metric = new Metric();
        long realTime = System.currentTimeMillis();
        if (!JmxUtil.hasAttributes(names)) {
            try {
                attl = JmxUtil.getAttributes(cnx, objname);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        } else {
            try {
                attl = JmxUtil.getAttributesForProvidedNames(cnx, objname, names, indicatorName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (JMException e) {
                e.printStackTrace();
            }
        }
        if (attl.isEmpty()) {
            this.logger.warn((Object)("No metrics found for indicator: " + indicatorName + ", for mbean: " + objname.toString() + ", and target: " + this.target.getName()), new Object[0]);
            return null;
        }
        metric.setMBean(objname);
        metric.setAttributeList(attl);
        metric.setTarget(this.target.getName());
        metric.setTimestamp(realTime);
        metric.setProperty("server", this.serverName);
        metric.setProperty("domain", this.domainName);
        metric.setProperty("url", this.targetUrl);
        return metric;
    }

    private void setMultiValue(List<String> attrlist, Metric m) {
        Attribute att;
        if (JmxUtil.hasAttributes(attrlist) && attrlist.size() == 1 && ComplexValuesUtil.hasSimpleType((att = (Attribute)m.getAttributeList().get(0)).getValue())) {
            m.setMultiValue(false);
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        if (this.cfactory == null) {
            this.cfactory = this.jmxConnectionService.getJmxConnectionFactory(this.targetUrl, this.targetProps);
        }
        MBeanServerConnection cnx = this.cfactory.getMBeanServerConnection();
        this.setServerAndDomain(cnx);
        return cnx;
    }

    protected void resetMBeanServerConnection() {
        this.jmxConnectionService.removeJmxConnectionFactory(this.targetUrl);
        this.cfactory = null;
    }

    private void setServerAndDomain(MBeanServerConnection cnx) {
        block12: {
            if (this.serverNameSet) {
                return;
            }
            try {
                this.domainName = "unknown_domain";
                this.serverName = "unknown";
                ObjectName on = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                Set<ObjectName> ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    this.domainName = serverOn.getDomain();
                    String name = serverOn.getKeyProperty("name");
                    if (name != null) {
                        this.serverNameSet = true;
                        this.serverName = name;
                    }
                    return;
                }
                on = ObjectName.getInstance("Catalina:*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "Catalina";
                    this.serverName = this.target.getName();
                    this.serverNameSet = true;
                    return;
                }
                on = ObjectName.getInstance("org.mortbay.jetty:type=server,*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "org.mortbay.jetty";
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    String serverId = serverOn.getKeyProperty("id");
                    this.serverName = serverId != null ? serverId : this.target.getName();
                    this.serverNameSet = true;
                    return;
                }
            }
            catch (JMException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.target.getName(), this.error});
                } else if (!this.error.equals(e.toString())) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.target.getName(), this.error});
                }
            }
            catch (IOException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.target.getName(), this.error});
                }
                if (this.error.equals(e.toString())) break block12;
                this.error = e.toString();
                this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.target.getName(), this.error});
            }
        }
    }
}

