/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentUtil;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxUtil;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxWorker
extends Thread {
    private Log logger = LogFactory.getLog(JmxWorker.class);
    private boolean started = false;
    private String targetName;
    private String url;
    private long workPeriod = 1000L;
    private static final long DEFAULT_PERIOD = 1000L;
    private static final long CONNECT_PERIOD = 60000L;
    private Collection<JmxCollector> collectors = new ArrayList<JmxCollector>();
    private JmxConnectionService jmxService;
    private Map<String, String> props = new HashMap<String, String>();
    private JmxConnectionFactory cfactory = null;
    private boolean lastConnected;
    private String serverName = null;
    private String domainName = null;
    private boolean serverNameSet = false;
    private String error;

    public JmxWorker(JasmineTarget target, JmxConnectionService jmxConnectionService) {
        this.targetName = target.getName();
        this.props = target.getProperties();
        this.url = this.props.get("url");
        this.logger.debug((Object)(this.targetName + " url=" + this.url), new Object[0]);
        this.jmxService = jmxConnectionService;
    }

    public synchronized void remove() {
        this.collectors.clear();
        this.started = false;
    }

    public synchronized void addCollector(JmxCollector col) {
        this.logger.debug((Object)"JmxWorker collect for target {0} on behalf of indicator {1} in probe {2}", new Object[]{this.targetName, col.getIndicatorName(), col.getProbeId()});
        this.collectors.add(col);
        if (!this.started) {
            this.started = true;
            this.start();
        }
    }

    public synchronized boolean hasCollector(JmxCollector col) {
        return this.collectors.contains((Object)col);
    }

    public synchronized boolean removeCollector(JmxCollector col) {
        return this.collectors.remove((Object)col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            Object removed;
            JmxWorker jmxWorker = this;
            synchronized (jmxWorker) {
                removed = new ArrayList<JmxCollector>();
                for (JmxCollector coll : this.collectors) {
                    if (!coll.isRemoved()) continue;
                    ((ArrayList)removed).add(coll);
                }
                Iterator<JmxCollector> i$ = ((ArrayList)removed).iterator();
                while (i$.hasNext()) {
                    JmxCollector coll;
                    coll = i$.next();
                    this.collectors.remove((Object)coll);
                }
            }
            ArrayList<JmxCollector> topoll = new ArrayList<JmxCollector>();
            removed = this;
            synchronized (removed) {
                for (JmxCollector coll : this.collectors) {
                    if (!coll.needResult()) continue;
                    topoll.add(coll);
                }
            }
            if (!topoll.isEmpty()) {
                long t = System.currentTimeMillis();
                MBeanServerConnection cnx = null;
                try {
                    cnx = this.getMBeanServerConnection();
                    this.lastConnected = true;
                }
                catch (JmxConnectionException e) {
                    this.logger.warn((Object)"Cannot get Jmx access to target {0} with url {1} - {2}", new Object[]{this.targetName, this.url, e.getMessage()});
                    this.lastConnected = false;
                }
                if (cnx != null) {
                    int i;
                    this.setServerAndDomain(cnx);
                    ArrayList topolls = new ArrayList();
                    for (i = 0; i < topoll.size(); ++i) {
                        JmxCollector colltopoll = (JmxCollector)((Object)topoll.get(i));
                        boolean findColl = false;
                        for (ArrayList arrayList : topolls) {
                            JmxCollector coll = (JmxCollector)((Object)arrayList.get(0));
                            if (!coll.getIndicatorName().equals(colltopoll.getIndicatorName()) || !coll.getProbeId().equals(colltopoll.getProbeId())) continue;
                            arrayList.add(colltopoll);
                            findColl = true;
                            break;
                        }
                        if (findColl) continue;
                        ArrayList<JmxCollector> newcoll = new ArrayList<JmxCollector>();
                        newcoll.add(colltopoll);
                        topolls.add(newcoll);
                    }
                    for (i = 0; i < topolls.size(); ++i) {
                        ArrayList colls = (ArrayList)topolls.get(i);
                        JmxCollector firstColl = (JmxCollector)((Object)colls.get(0));
                        List<Metric> metrics = this.collect(cnx, firstColl);
                        for (JmxCollector coll : colls) {
                            coll.addResult(metrics);
                        }
                        colls.clear();
                    }
                    topolls.clear();
                    topoll.clear();
                }
            }
            JmxWorker jmxWorker2 = this;
            synchronized (jmxWorker2) {
                try {
                    if (!this.lastConnected) {
                        this.workPeriod = 60000L;
                        this.resetMBeanServerConnection();
                    } else if (this.workPeriod == 60000L) {
                        this.workPeriod = 1000L;
                    }
                    this.wait(this.workPeriod);
                }
                catch (InterruptedException e) {
                    this.logger.warn((Object)(this.getName() + ": collector interrupted"), new Object[]{e});
                }
                catch (Exception e) {
                    this.logger.warn((Object)(this.getName() + ": collector exception"), new Object[]{e});
                }
            }
        }
    }

    private MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        if (this.cfactory == null) {
            this.cfactory = this.jmxService.getJmxConnectionFactory(this.url, this.props);
        }
        return this.cfactory.getMBeanServerConnection();
    }

    private void resetMBeanServerConnection() {
        this.jmxService.removeJmxConnectionFactory(this.url);
        this.cfactory = null;
    }

    private void setServerAndDomain(MBeanServerConnection cnx) {
        block12: {
            if (this.serverNameSet) {
                return;
            }
            try {
                this.domainName = "unknown_domain";
                this.serverName = "unknown";
                ObjectName on = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                Set<ObjectName> ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    this.domainName = serverOn.getDomain();
                    String name = serverOn.getKeyProperty("name");
                    if (name != null) {
                        this.serverNameSet = true;
                        this.serverName = name;
                    }
                    return;
                }
                on = ObjectName.getInstance("Catalina:*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "Catalina";
                    this.serverName = this.targetName;
                    this.serverNameSet = true;
                    return;
                }
                on = ObjectName.getInstance("org.mortbay.jetty:type=server,*");
                ons = cnx.queryNames(on, null);
                if (!ons.isEmpty()) {
                    this.domainName = "org.mortbay.jetty";
                    Iterator<ObjectName> onames = ons.iterator();
                    ObjectName serverOn = onames.next();
                    String serverId = serverOn.getKeyProperty("id");
                    this.serverName = serverId != null ? serverId : this.targetName;
                    this.serverNameSet = true;
                    return;
                }
            }
            catch (JMException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.targetName, this.error});
                } else if (!this.error.equals(e.toString())) {
                    this.error = e.toString();
                    this.logger.warn((Object)"Cannot get server and domain names for target {0} ({1})", new Object[]{this.targetName, this.error});
                }
            }
            catch (IOException e) {
                if (this.error == null) {
                    this.error = e.toString();
                    this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.targetName, this.error});
                }
                if (this.error.equals(e.toString())) break block12;
                this.error = e.toString();
                this.logger.error((Object)"A communication problem occurred with target {0} ({1})", new Object[]{this.targetName, this.error});
            }
        }
    }

    private List<Metric> collect(MBeanServerConnection cnx, JmxCollector col) {
        LinkedList<Metric> metrics = new LinkedList<Metric>();
        try {
            ObjectName objname = col.getObjectName();
            if (objname.isPattern()) {
                this.logger.debug((Object)("collect pattern:" + objname.toString()), new Object[0]);
                Set<ObjectName> onset = JmxUtil.getMBeans(cnx, objname);
                if (onset.isEmpty()) {
                    this.logger.warn((Object)"No MBeans found for pattern {0} in this collector (indicator: {1})", new Object[]{objname.toString(), col.getIndicator().getName()});
                }
                for (ObjectName on : onset) {
                    Metric m = this.getMBeanMetric(cnx, on, col);
                    if (m == null) continue;
                    this.checkMultiValue(col, m);
                    metrics.add(m);
                }
            } else {
                this.logger.debug((Object)("collect single mbean:" + objname.toString()), new Object[0]);
                if (cnx.isRegistered(objname)) {
                    Metric m = this.getMBeanMetric(cnx, objname, col);
                    if (m != null) {
                        this.checkMultiValue(col, m);
                        metrics.add(m);
                    }
                } else {
                    this.logger.error((Object)"Cannot collect from MBean {0} (does not exists)", new Object[]{objname});
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)("getAttributes error on JmxServer: " + e), new Object[0]);
        }
        this.logger.debug((Object)("nb of metrics found: " + metrics.size()), new Object[0]);
        return metrics;
    }

    private void checkMultiValue(JmxCollector col, Metric m) {
        Attribute att;
        if (col.hasAttributes() && col.getAttrlist().size() == 1 && ComplexValuesUtil.hasSimpleType((att = (Attribute)m.getAttributeList().get(0)).getValue())) {
            m.setMultiValue(false);
        }
    }

    private Metric getMBeanMetric(MBeanServerConnection cnx, ObjectName objname, JmxCollector col) throws IOException, JMException {
        this.logger.debug((Object)("mbean:" + objname.toString()), new Object[0]);
        List<String> allAttNames = JmxUtil.getMBeanAttNames(cnx, objname);
        AttributeList attl = new AttributeList();
        Metric metric = new Metric();
        attl = !col.hasAttributes() ? this.getAllAttributes(cnx, objname, allAttNames, metric) : this.getAttributesForProvidedNames(cnx, objname, allAttNames, col.getAttrlist(), col.getIndicatorName(), metric);
        if (attl.isEmpty()) {
            this.logger.warn((Object)("No metrics found for indicator: " + col.getIndicator().getName() + ", for mbean: " + objname.toString() + ", and target: " + this.targetName), new Object[0]);
            return null;
        }
        metric.setMBean(objname);
        metric.setAttributeList(attl);
        metric.setTarget(this.targetName);
        metric.setProperty("server", this.serverName);
        metric.setProperty("domain", this.domainName);
        metric.setProperty("url", this.url);
        return metric;
    }

    private AttributeList getAllAttributes(MBeanServerConnection cnx, ObjectName objname, List<String> allAttNames, Metric metric) throws IOException, JMException {
        long realTime = System.currentTimeMillis();
        AttributeList attl = cnx.getAttributes(objname, allAttNames.toArray(new String[0]));
        metric.setTimestamp(realTime);
        this.logger.debug((Object)"All attributes polled for MBean {0} :", new Object[]{objname.toString()});
        for (String nameToPoll : allAttNames) {
            this.logger.debug((Object)nameToPoll, new Object[0]);
        }
        return attl;
    }

    private AttributeList getAttributesForProvidedNames(MBeanServerConnection cnx, ObjectName objname, List<String> allAttNames, Collection<String> names, String indicName, Metric metric) throws IOException, JMException {
        AttributeList attl = new AttributeList();
        HashMap<String, String> attNamesToPoll = new HashMap<String, String>();
        HashMap<String, Attribute> attsToPoll = new HashMap<String, Attribute>();
        for (String name : names) {
            if (FragmentUtil.isFragmentName(name)) {
                try {
                    String attName = FragmentUtil.getAttributeName(name);
                    if (allAttNames.contains(attName)) {
                        attNamesToPoll.put(name, attName);
                        continue;
                    }
                    this.logger.error((Object)"Cannot poll fragment {0} (no attribute named {1} exists in MBean {2})", new Object[]{name, attName, objname});
                }
                catch (FragmentNameException e) {
                    this.logger.error((Object)"Cannot poll fragment {0}, incorrect format !", new Object[0]);
                }
                continue;
            }
            if (allAttNames.contains(name)) {
                attNamesToPoll.put(name, name);
                continue;
            }
            this.logger.error((Object)"Cannot poll attribute {0} (does not exists in MBean {1})", new Object[]{name, objname});
        }
        if (attNamesToPoll.keySet().isEmpty()) {
            this.logger.info((Object)"No attributes to poll in MBean {0} (based on indicator {0} definition)", new Object[]{objname, indicName});
            return attl;
        }
        this.logger.debug((Object)"names to poll:", new Object[0]);
        for (String nameToPoll : attNamesToPoll.keySet()) {
            this.logger.debug((Object)nameToPoll, new Object[0]);
        }
        this.logger.debug((Object)"corresponding attribute names:", new Object[0]);
        String[] attNames = new String[attNamesToPoll.keySet().size()];
        int i = 0;
        for (String nameToPoll : attNamesToPoll.keySet()) {
            attNames[i++] = (String)attNamesToPoll.get(nameToPoll);
            this.logger.debug(attNamesToPoll.get(nameToPoll), new Object[0]);
        }
        long realTime = System.currentTimeMillis();
        AttributeList atts = cnx.getAttributes(objname, attNames);
        metric.setTimestamp(realTime);
        for (String nameToPoll : attNamesToPoll.keySet()) {
            String attName = (String)attNamesToPoll.get(nameToPoll);
            attsToPoll.put(nameToPoll, this.getAttribute(atts, attName));
        }
        for (String name : attsToPoll.keySet()) {
            if (FragmentUtil.isFragmentName(name)) {
                try {
                    Attribute att = JmxUtil.getAttributeFragment(name, (Attribute)attsToPoll.get(name));
                    attl.add(att);
                }
                catch (FragmentNameException e) {
                    this.logger.error((Object)"Cannot poll fragment {0} ({1})", new Object[]{name, e.toString()});
                }
                continue;
            }
            attl.add((Attribute)attsToPoll.get(name));
        }
        return attl;
    }

    private Attribute getAttribute(AttributeList atts, String attName) {
        for (Attribute att : atts.asList()) {
            if (!att.getName().equals(attName)) continue;
            return att;
        }
        return null;
    }
}

