/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.ow2.jasmine.probe.collectors.jmx.internal.ComplexValuesException;

public class ComplexValuesUtil {
    public static Object getTabElement(Object value, String index) throws ComplexValuesException {
        Object element = null;
        TabularData tabData = (TabularData)value;
        Collection<?> values = tabData.values();
        for (Object tabValue : values) {
            CompositeData compositeValue = (CompositeData)tabValue;
            try {
                Object[] tabIndexes = tabData.calculateIndex(compositeValue);
                if (tabIndexes.length == 1) {
                    String tabIndex = (String)tabIndexes[0];
                    if (!tabIndex.equals(index)) continue;
                } else {
                    throw new ComplexValuesException("Complex values having multi-index TabularType are not yet supported");
                }
                element = tabValue;
                break;
            }
            catch (Exception e) {
                throw new ComplexValuesException("Exception when trying to access a TabularData's element with index: " + index);
            }
        }
        return element;
    }

    public static Object getArrayElement(Object value, String index) throws ComplexValuesException, ClassCastException {
        Object element = null;
        try {
            int i = Integer.parseInt(index);
            element = Array.get(value, i);
        }
        catch (NumberFormatException nfe) {
            throw new ComplexValuesException("Element has unsupported index format:" + index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ComplexValuesException("Cannot access array element with out of range index: " + index);
        }
        return element;
    }

    public static Object getListElement(Object value, String index) throws ComplexValuesException {
        Object element = null;
        try {
            int i = Integer.parseInt(index);
            List lvalue = (List)value;
            element = lvalue.get(i);
        }
        catch (NumberFormatException nfe) {
            throw new ComplexValuesException("Element has unsupported index format:" + index.toString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new ComplexValuesException("Cannot access list element with out of range index: " + index);
        }
        return element;
    }

    public static Object getCompositeItem(Object value, String key) throws ComplexValuesException {
        CompositeData compositeValue = (CompositeData)value;
        Set<String> keys = compositeValue.getCompositeType().keySet();
        for (String _key : keys) {
            if (!key.equals(_key)) continue;
            Object item = compositeValue.get(key);
            return item;
        }
        throw new ComplexValuesException("CompositeData value has no key equal to " + key);
    }

    public static Object getMapItem(Object value, String key) throws ComplexValuesException {
        Map mapValue = (Map)value;
        Set keys = mapValue.keySet();
        for (Object _key : keys) {
            try {
                String sKey = (String)_key;
                if (!key.equals(sKey)) continue;
                Object item = mapValue.get(sKey);
                return item;
            }
            catch (ClassCastException e) {
                throw new ComplexValuesException("Complex object has a Map type with non String keys !");
            }
        }
        throw new ComplexValuesException("Map type value has no key equal to " + key);
    }

    public static Object getElement(Object value, String index) throws ComplexValuesException {
        if (value instanceof TabularData) {
            Object element = ComplexValuesUtil.getTabElement(value, index);
            if (element == null) {
                throw new ComplexValuesException("Cannot access Tabular element with inexistent index: " + index);
            }
            return element;
        }
        if (value instanceof List) {
            return ComplexValuesUtil.getListElement(value, index);
        }
        try {
            return ComplexValuesUtil.getArrayElement(value, index);
        }
        catch (ClassCastException cce) {
            throw new ComplexValuesException("Indexed elements other then TabularType, List, Array or Object[] are not supported");
        }
    }

    public static Object getItem(Object value, String key) throws ComplexValuesException {
        Object item = null;
        boolean found = false;
        if (value instanceof CompositeData) {
            return ComplexValuesUtil.getCompositeItem(value, key);
        }
        if (value instanceof Map) {
            return ComplexValuesUtil.getMapItem(value, key);
        }
        throw new ComplexValuesException("Complex object has neither a Map type value, nor a CompositeData value !");
    }

    public static boolean hasSimpleType(Object value) {
        return value instanceof Number || value instanceof String || value instanceof ObjectName || value instanceof Boolean;
    }
}

