/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import org.ow2.jasmine.probe.collectors.jmx.internal.FragmentNameException;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollector;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class FragmentUtil {
    private static Log logger = LogFactory.getLog(JmxCollector.class);
    public static String DOT = ".";
    public static String COMMA = ",";
    public static String BRACKLEFT = "[";
    public static String BRACKRIGHT = "]";

    public static boolean isFragmentName(String name) {
        if (name.contains(DOT)) {
            return true;
        }
        return name.contains(BRACKLEFT) && name.contains(BRACKLEFT) && name.indexOf(BRACKLEFT) < name.indexOf(BRACKRIGHT);
    }

    public static String getNameForItem(String name, String key) {
        String itemName = name + DOT + key;
        return itemName;
    }

    public static String getNameForElem(String name, String elemName) {
        String elem = elemName.substring(0, elemName.indexOf(BRACKLEFT));
        int elemIndex = name.indexOf(elem);
        String name_firstPart = name.substring(0, elemIndex);
        String name_secondPart = elemName;
        return new String(name_firstPart + name_secondPart);
    }

    public static String getNameForArrayElement(String name, String index) {
        String elemName = name + BRACKLEFT + index + BRACKRIGHT;
        return elemName;
    }

    public static String getNameForTabularElement(String name, Object[] indexes) {
        String s_indexes = indexes[0].toString();
        if (indexes.length > 1) {
            for (int i = 1; i < indexes.length; ++i) {
                s_indexes = s_indexes + COMMA + indexes[i];
            }
        }
        String elemName = name + BRACKLEFT + s_indexes + BRACKRIGHT;
        return elemName;
    }

    public static String getItemName(String fragmentName) throws FragmentNameException {
        int dotIndex = fragmentName.indexOf(DOT);
        if (dotIndex > 0) {
            return fragmentName.substring(dotIndex + 1);
        }
        throw new FragmentNameException("Can't get item name from: " + fragmentName);
    }

    public static String getElementName(String fragmentName) throws FragmentNameException {
        int brackLeftIndex = fragmentName.indexOf(BRACKLEFT);
        int brackRightIndex = fragmentName.indexOf(BRACKRIGHT);
        if (brackLeftIndex > 0 && brackRightIndex > 0 && brackLeftIndex < brackRightIndex) {
            return fragmentName;
        }
        throw new FragmentNameException("Can't get element name from: " + fragmentName);
    }

    public static String nameForIndexElement(String name, String index) {
        String elemName = name + BRACKLEFT + index + BRACKRIGHT;
        return elemName;
    }

    public static String nameForItem(String name, String key) {
        String itemName = name + DOT + key;
        return itemName;
    }

    public static String getAttributeName(String name) throws FragmentNameException {
        int dotIndex = name.indexOf(DOT);
        int brackLeftIndex = name.indexOf(BRACKLEFT);
        if (dotIndex < 0 && brackLeftIndex < 0) {
            throw new FragmentNameException("Can't get attribute name from: " + name);
        }
        int index = dotIndex > 0 && brackLeftIndex < 0 ? dotIndex : (brackLeftIndex > 0 && dotIndex < 0 ? brackLeftIndex : (dotIndex < brackLeftIndex ? dotIndex : brackLeftIndex));
        return name.substring(0, index);
    }

    public static String getKeyName(String name, String attributeName) {
        String elements = name.substring(attributeName.length());
        int dotIndex = elements.indexOf(DOT);
        elements = elements.substring(dotIndex + 1);
        dotIndex = elements.indexOf(DOT);
        int brackLeftIndex = elements.indexOf(BRACKLEFT);
        if (dotIndex < 0 && brackLeftIndex < 0) {
            return elements;
        }
        if (dotIndex > 0 && brackLeftIndex < 0) {
            return elements.substring(0, dotIndex);
        }
        if (brackLeftIndex > 0 && dotIndex < 0) {
            return elements.substring(0, brackLeftIndex);
        }
        if (dotIndex < brackLeftIndex) {
            return elements.substring(0, dotIndex);
        }
        return elements.substring(0, brackLeftIndex);
    }

    public static String getIndexes(String name, String attributeName) throws FragmentNameException {
        try {
            int brackLeftIndex = name.indexOf(BRACKLEFT);
            int brackRightIndex = name.indexOf(BRACKRIGHT);
            String indexes = name.substring(brackLeftIndex + 1, brackRightIndex);
            return indexes;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". It was expected to start with " + attributeName + " and continue with an indexed element");
        }
    }

    public static String getElementName(String name, String attributeName) throws FragmentNameException {
        if (name.indexOf(attributeName) != 0) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". It was expected to start with " + attributeName);
        }
        try {
            String elements = name.substring(attributeName.length(), name.length());
            if (elements.startsWith(DOT)) {
                return FragmentUtil.getKeyName(name, attributeName);
            }
            if (elements.startsWith(BRACKLEFT)) {
                if (elements.indexOf(BRACKRIGHT) > 0) {
                    return FragmentUtil.getIndexes(name, attributeName);
                }
                throw new FragmentNameException("Malformed fragment name: . Didn't found expected right bracket.");
            }
            throw new FragmentNameException("Malformed fragment name: " + name + ". Didn't recognize any attibute element after " + attributeName);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". It was expected to start with " + attributeName);
        }
    }

    public static boolean nextElementIsKey(String name, String attributeName) throws FragmentNameException {
        if (name.indexOf(attributeName) != 0) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". It was expected to start with " + attributeName);
        }
        try {
            String elements = name.substring(attributeName.length(), name.length());
            return elements.startsWith(DOT);
        }
        catch (IndexOutOfBoundsException e) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". An attribute element expected after " + attributeName);
        }
    }

    public static boolean nextElementIsIndex(String name, String attributeName) throws FragmentNameException {
        if (name.indexOf(attributeName) != 0) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". It was expected to start with " + attributeName);
        }
        try {
            String elements = name.substring(attributeName.length(), name.length());
            if (elements.startsWith(BRACKLEFT)) {
                if (elements.indexOf(BRACKRIGHT) > 0) {
                    return true;
                }
                throw new FragmentNameException("Malformed fragment name: . Didn't found expected right bracket.");
            }
            return false;
        }
        catch (IndexOutOfBoundsException e) {
            throw new FragmentNameException("Malformed fragment name: " + name + ". An attribute element expected after " + attributeName);
        }
    }
}

