/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.List;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollectorBase;

public class JmxCollector
extends JmxCollectorBase {
    private List<Metric> metrics = null;
    private List<Metric> cache = null;
    private boolean stopped = false;

    public JmxCollector(String probeId, JasmineIndicator indicator, int period, String mbean, String csv) {
        super(probeId, indicator, period, mbean, csv);
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        this.cache = this.metrics;
        this.metrics = null;
        if (this.cache == null) {
            this.logger.warn((Object)"Cannot return value for indicator {0} (no available metrics)", new Object[]{this.getIndicatorName()});
            return null;
        }
        JasmineIndicatorValue jiv = this.getJiv(this.getIndicatorName(), this.getProbeId(), this.getIndicator().getScale(), this.cache);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = true;
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
        this.stopped = false;
    }

    public boolean needResult() {
        if (this.stopped) {
            this.logger.debug((Object)("STOPPED, need no result for " + this.indicator.getName() + " in probe " + this.probeId), new Object[0]);
            return false;
        }
        if (this.metrics == null) {
            return true;
        }
        long timestamp = this.metrics.get(0).getTimestamp();
        return this.oldvalue(timestamp);
    }

    public void addResult(List<Metric> metrics) {
        if (metrics.size() == 0) {
            this.logger.debug((Object)"Empty metric list", new Object[0]);
            return;
        }
        this.logger.debug((Object)"", new Object[0]);
        this.metrics = metrics;
    }

    private boolean oldvalue(long timestamp) {
        long now = System.currentTimeMillis();
        return now - timestamp > (long)(this.period * 1000);
    }
}

