/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.jmx.internal;

import java.util.List;
import javax.management.ObjectName;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineTarget;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.jmx.Metric;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxCollectorBase;
import org.ow2.jasmine.probe.collectors.jmx.internal.JmxProxy;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;

public class JmxCollectorSimple
extends JmxCollectorBase {
    private ObjectName objname = this.getObjectName();
    private List<Metric> metrics = null;
    protected int nb = 1;
    private int nbGetLastResult;
    private JmxProxy jmxProxy = new JmxProxy();

    public JmxCollectorSimple(String probeId, JasmineIndicator indicator, int period, String mbean, String csv) throws JasmineCollectorException {
        super(probeId, indicator, period, mbean, csv);
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        JasmineIndicatorValue resultValue = null;
        if (this.metrics == null) {
            try {
                this.metrics = this.jmxProxy.collectMetrics(this.objname, this.getIndicatorName(), this.getAttrlist());
            }
            catch (JmxConnectionException jmxConnectionException) {
                // empty catch block
            }
            this.nbGetLastResult = this.nb;
        }
        if (this.nbGetLastResult > 0) {
            if (this.metrics == null) {
                this.logger.warn((Object)"Cannot return value for indicator {0} (no available metrics)", new Object[]{this.getIndicatorName()});
                return null;
            }
            if (this.metrics.isEmpty()) {
                this.logger.warn((Object)"No metrics for indicator {0} in probe {1}", new Object[]{this.getIndicatorName(), this.getProbeId()});
                return null;
            }
            resultValue = this.getJiv(this.getIndicatorName(), this.getProbeId(), this.getIndicator().getScale(), this.metrics);
            this.logger.debug((Object)"Return result for indicator {0} in probe {1} with timestamp {2}", new Object[]{this.getIndicatorName(), this.getProbeId(), resultValue.getTimestamp()});
            --this.nbGetLastResult;
            if (this.nbGetLastResult == 0) {
                this.metrics = null;
            }
        }
        return resultValue;
    }

    public void startPolling() {
        this.logger.debug((Object)("Start " + this.getIndicatorName() + " in probe " + this.getProbeId()), new Object[0]);
    }

    public void stopPolling() {
        this.logger.debug((Object)("Stop " + this.getIndicatorName() + " in probe " + this.getProbeId()), new Object[0]);
    }

    public void remove() {
        super.remove();
        this.jmxProxy.resetMBeanServerConnection();
        this.jmxProxy = null;
    }

    protected void setJmxConnectionService(JmxConnectionService jmxConnectionService) {
        this.jmxProxy.setJmxConnectionService(jmxConnectionService);
    }

    protected void setTarget(JasmineTarget target) {
        this.jmxProxy.setTarget(target);
    }
}

