/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LewysParams.java 8733 2011-08-10 09:51:06Z danesa $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.collectors.lewys.shell;

import org.ow2.jasmine.probe.shell.JasmineProbeCommandParams;

import com.beust.jcommander.Parameter;

/**
 * Describes params for lewys commands
 * @author durieuxp
 */
public class LewysParams extends JasmineProbeCommandParams {

    @Parameter(names = { "-n", "--name" }, description = "Name of the indicator to create", required = true)
    public String name = null;

    public String getName() {
        return name;
    }

    @Parameter(names = { "-c", "--command" }, description = "Lewys Command name (disk|memory|network|kernel|cpu)", required = true)
    private String command;

    @Parameter(names = { "-r", "--resources" }, description = "CSV list of resources", required = false)
    private String resources;

    /**
     * get value for the "cmd" property.
     * See LewysCollectorService for property definitions
     * @return
     */
    public String getCmd() {
        return command;
    }

    /**
     * get value for the "resources" property.
     * See LewysCollectorService for property definitions
     * @return
     */
    public String getResources() {
        return resources;
    }

    public void reset() {
        name = null;
        command = null;
        resources = null;
    }

}
