/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JMergeCollector.java 9051 2011-10-04 08:41:24Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.collectors.merge.internal;

import java.util.Collection;
import java.util.HashMap;

import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

/**
 * Merge collector implementation.
 * This is a simplified version of the aggregate collector.
 * Should be deprecated when aggregate is fully working.
 * @author durieuxp
 * @author danesa
 */
public class JMergeCollector extends JCollector {

    /**
     * Built-in aggregate operation code.
     */
    private int ope;

    /**
     * Requested operation (aggregate function).
     */
    private String operation;

    /**
     * List of supported operations
     */
    public final static int OP_MIN = 1;
    public final static int OP_MAX = 2;
    public final static int OP_SUM = 3;
    public final static int OP_AVERAGE = 4;

    private JasmineCollector source = null;

    /**
     * Constructor
     * @param name
     * @param def
     * @param period
     * @param source
     */
    public JMergeCollector(String name, JasmineIndicator def, int period, String operation, JasmineCollector source, String merged) {
        super(name, def, period);
        this.operation = operation;
        ope = 0;
        if (operation.equalsIgnoreCase("min")) {
            ope = OP_MIN;
        } else if (operation.equalsIgnoreCase("max")) {
            ope = OP_MAX;
        }  else if (operation.equalsIgnoreCase("sum")) {
            ope = OP_SUM;
        }  else if (operation.equalsIgnoreCase("average")) {
            ope = OP_AVERAGE;
        }
        this.source = source;
    }

    /**
     * return the last result for this indicator
     * @return JasmineIndicatorValue
     * @throws org.ow2.jasmine.probe.collector.JasmineCollectorException
     */
    @Override
    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        logger.debug("");
        JasmineIndicatorValue current = source.getLastResult();
        if (current == null) {
            return null;
        }
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        jiv.setName(indicator.getName());
        jiv.addMetadata("op", operation);

        // Keep almost all metadata from source indicator (server, domain, ...)
        for (String key : current.getMetadata().keySet()) {
            if (!key.equals("op")) {
                 jiv.addMetadata(key, current.getMetadata().get(key));
            }
        }
        jiv.setTarget(current.getTarget());

        Collection<JasmineSingleResult> jsrs = current.getValues();

        long timestamp = System.currentTimeMillis();

        // Props for JSR to construct
        HashMap<String, String> jsrProps = jsrProps(jsrs);

        JasmineSingleResult jsrm = new JasmineSingleNumberResult();

        Number resval = null;
        switch (ope) {
            case OP_MAX:
                resval = maxJsr(jsrs);
                break;
            case OP_MIN:
                resval = minJsr(jsrs);
                break;
            case OP_SUM:
                resval = addJsr(jsrs);
                break;
            case OP_AVERAGE:
                resval = averageJsr(jsrs);
                break;
            default:
                throw new JasmineCollectorException("Unimplemented merge operation " + ope);
        }
        jsrm.setName(indicator.getName());
        jsrm.setTimestamp(timestamp);
        jsrm.setValue(resval);
        jsrm.setProperties(jsrProps);
        jiv.addValue(jsrm);
        return jiv;
    }

    /**
     * Stop polling
     */
    public void stopPolling() {
        logger.debug("");
        // nothing to do
    }

    /**
     * Start polling
     */
    @Override
    public void startPolling() {
        logger.debug("");
        // nothing to do
    }

}
