/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.probe.collectors.slope.internal;

import java.util.HashMap;
import java.util.Iterator;
import org.ow2.jasmine.probe.JasmineIndicator;
import org.ow2.jasmine.probe.JasmineIndicatorValue;
import org.ow2.jasmine.probe.JasmineSingleNumberResult;
import org.ow2.jasmine.probe.JasmineSingleResult;
import org.ow2.jasmine.probe.collector.JasmineCollector;
import org.ow2.jasmine.probe.collector.JasmineCollectorException;
import org.ow2.jasmine.probe.collectors.JCollector;

public class SlopeCollector
extends JCollector {
    private JasmineCollector numerator;
    private JasmineCollector denominator;
    private Number numprevious = null;
    private Number denprevious = null;

    public SlopeCollector(String key, JasmineIndicator indic, int period, JasmineCollector n, JasmineCollector d) {
        super(key, indic, period);
        this.numerator = n;
        this.denominator = d;
    }

    public JasmineIndicatorValue getLastResult() throws JasmineCollectorException {
        JasmineSingleResult jsr1;
        this.logger.debug((Object)"", new Object[0]);
        JasmineIndicatorValue jiv = new JasmineIndicatorValue();
        JasmineSingleNumberResult jsr = new JasmineSingleNumberResult();
        long timestamp = System.currentTimeMillis();
        Number result = 0;
        Number numval = null;
        Number denval = null;
        JasmineIndicatorValue jivnum = this.numerator.getLastResult();
        if (jivnum == null || jivnum.getValues().isEmpty()) {
            this.logger.warn((Object)"No result available on source indicator for numerator {0}", new Object[]{this.numerator.getName()});
            return null;
        }
        JasmineIndicatorValue jivden = this.denominator.getLastResult();
        if (jivden == null || jivden.getValues().isEmpty()) {
            this.logger.warn((Object)"No result available on source indicator for denominator {0}", new Object[]{this.denominator.getName()});
            return null;
        }
        if (jivnum.getValues().size() > 1 || jivden.getValues().size() > 1) {
            this.logger.warn((Object)"Slope on multivalued indicator not supported", new Object[0]);
            throw new JasmineCollectorException("Slope on multivalued indicator not supported");
        }
        String tnum = jivnum.getTarget();
        String tden = jivden.getTarget();
        if (tnum != null) {
            if (tden != null) {
                if (tnum.equals(tden)) {
                    jiv.setTarget(tden);
                } else {
                    jiv.setTarget("misc");
                }
            } else {
                jiv.setTarget(tden);
            }
        } else if (tden != null) {
            jiv.setTarget(tden);
        }
        String domain = null;
        String d = (String)jivnum.getMetadata().get("domain");
        if (d != null) {
            domain = d;
        }
        if ((d = (String)jivden.getMetadata().get("domain")) != null) {
            if (domain == null) {
                domain = d;
            } else if (!d.equals(domain)) {
                domain = "misc";
            }
        }
        jiv.addMetadata("domain", domain);
        String server = null;
        String s = (String)jivnum.getMetadata().get("server");
        if (s != null) {
            server = s;
        }
        if ((s = (String)jivden.getMetadata().get("server")) != null) {
            if (server == null) {
                server = s;
            } else if (!s.equals(server)) {
                server = "misc";
            }
        }
        jiv.addMetadata("server", server);
        HashMap jsrProps = new HashMap();
        Iterator i$ = jivnum.getValues().iterator();
        if (i$.hasNext()) {
            jsr1 = (JasmineSingleResult)i$.next();
            numval = (Number)jsr1.getValue();
            jsrProps.putAll(jsr1.getProperties());
        }
        if ((i$ = jivden.getValues().iterator()).hasNext()) {
            jsr1 = (JasmineSingleResult)i$.next();
            denval = (Number)jsr1.getValue();
            jsrProps.putAll(jsr1.getProperties());
        }
        if (this.numprevious == null || this.denprevious == null) {
            this.logger.debug((Object)"First call: No previous value yet", new Object[0]);
            this.numprevious = numval;
            this.denprevious = denval;
            return null;
        }
        Long diff1 = this.diffValues(numval, this.numprevious);
        Long diff2 = this.diffValues(denval, this.denprevious);
        result = Float.valueOf(this.divideValues(diff1, diff2));
        if (this.indicator.getScale() != 1) {
            result = Float.valueOf(this.divideValues(result, this.indicator.getScale()));
        }
        jsr.setTimestamp(timestamp);
        jsr.setValue((Object)result);
        jsr.setName(this.indicator.getName());
        jsr.setProperties(jsrProps);
        jiv.setName(this.indicator.getName());
        jiv.addValue((JasmineSingleResult)jsr);
        return jiv;
    }

    public void stopPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }

    public void startPolling() {
        this.logger.debug((Object)"", new Object[0]);
    }
}

