package org.ow2.jasmine.probe.jmxconnection.simple;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxConnectionFactoryImpl implements JmxConnectionFactory {

    private JMXConnector connector = null;

    private String url = null;

    private static Log logger = LogFactory.getLog(JmxConnectionService.class);

    /**
     * Constructor
     * @param url
     * @param env
     */
    public JmxConnectionFactoryImpl(String url, Map<String, Object> env) throws JmxConnectionException {

        logger.debug(url);

        // Check URL
        this.url = url;
        JMXServiceURL serviceUrl = null;
        try {
            serviceUrl = new JMXServiceURL(url);
        } catch (MalformedURLException e) {
            throw new JmxConnectionException(e);
        }

        // Create a connector client for the connector server at the given serviceUrl
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            connector = JMXConnectorFactory.connect(serviceUrl, env);
            logger.info("Connector created for target {0}.", url);
        } catch (SecurityException e) {
            logger.info("SecurityException raised for target {0}.", url);
            throw new JmxConnectionException(e);
        } catch (IOException e) {
            // The connector client cannot be made or connection
            // cannot be established because of a communication problem,
            e.printStackTrace();
            logger.info("IOException raised when trying to connect to target {0}: {1}", url, e.getMessage());
            throw new JmxConnectionException(e);
        } finally {
            Thread.currentThread().setContextClassLoader(old);
        }

    }

    public void close() throws JmxConnectionException {
        // remove the Connector
        try {
            connector.close();
            logger.info("JMX connection closed for target {0}", url);
        } catch (IOException e) {
            logger.warn("Exception when trying to close JMX connector for target {0} ({1})", url, e.toString());
            throw new JmxConnectionException(e);
        }
    }

    public MBeanServerConnection getMBeanServerConnection() throws JmxConnectionException {
        MBeanServerConnection mbsc = null;
        try {
            mbsc = connector.getMBeanServerConnection();
        } catch (IOException e) {
            logger.info("IOException raised when trying to get connection to target {0}: {1}", url, e.getMessage());
            throw new JmxConnectionException(e);
        }
        return mbsc;
    }

}
