/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmxConnectionServiceImpl.java 8560 2011-07-19 12:50:28Z durieuxp $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.probe.jmxconnection.simple;

import java.util.HashMap;
import java.util.Map;

import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionException;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionFactory;
import org.ow2.jasmine.probe.jmxconnection.JmxConnectionService;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/**
 * Simple (non pooled) implementation of the JmxConnectionService.
 * @author danesa
 */
@Component(name="JmxConnectionService", public_factory=false)
@Provides
public class JmxConnectionServiceImpl implements JmxConnectionService {

    @ServiceProperty(value="basic")
    private String nature;

    /**
     * For each URL: gives the JmxConnectionFactory
     */
    private Map<String, JmxConnectionFactoryImpl> factories = new HashMap<String, JmxConnectionFactoryImpl>();

    private static Log logger = LogFactory.getLog(JmxConnectionService.class);

    @Validate
    public void start() {
        logger.debug("JmxConnectionService activated.");
    }

    @Invalidate
    public void stop() {
        logger.debug("JmxConnectionService stopped.");
    }

    /**
     * Get the JmxConnectionFactory for these parameters.
     * @param url jmx url for the target
     * @param env properties for connector creation
     * @throws JmxConnectionException Thrown if connector could not be created, contains the cause.
     */
    public synchronized JmxConnectionFactory getJmxConnectionFactory(String url, Map<String, Object> env)
            throws JmxConnectionException {
        logger.debug(url);
        JmxConnectionFactoryImpl fact = factories.get(url);
        if (fact == null) {
            fact = new JmxConnectionFactoryImpl(url, env);
            factories.put(url, fact);
        }
        return fact;
    }

}
