/**
 * JASMINe
 * Copyright (C) 2011 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JmxConnectionService.java 8762 2011-08-26 14:37:33Z danesa $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.probe.jmxconnection;

import java.util.Map;

/**
 * Main interface of the OSGi service.
 */
public interface JmxConnectionService {
    /**
     * Get the JmxConnectionFactory for these parameters.
     *
     * @param targetUrl jmx url for the target
     * @param env       properties for connector creation
     * @throws JmxConnectionException Thrown if connector could not be created, contains the cause.
     */
    JmxConnectionFactory getJmxConnectionFactory(final String targetUrl, final Map<String, String> env) throws JmxConnectionException;

}
